/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.protocol.socket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import org.apache.nifi.cluster.ClusterNodeInformation;
import org.apache.nifi.cluster.NodeInformant;
import org.apache.nifi.cluster.NodeInformation;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.remote.Peer;
import org.apache.nifi.remote.RootGroupPort;
import org.apache.nifi.remote.StandardVersionNegotiator;
import org.apache.nifi.remote.VersionNegotiator;
import org.apache.nifi.remote.codec.FlowFileCodec;
import org.apache.nifi.remote.exception.HandshakeException;
import org.apache.nifi.remote.protocol.CommunicationsSession;
import org.apache.nifi.remote.protocol.RequestType;
import org.apache.nifi.remote.protocol.ServerProtocol;
import org.apache.nifi.remote.protocol.socket.HandshakeProperty;
import org.apache.nifi.remote.protocol.socket.ResponseCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterManagerServerProtocol
implements ServerProtocol {
    public static final String RESOURCE_NAME = "SocketFlowFileProtocol";
    private final VersionNegotiator versionNegotiator = new StandardVersionNegotiator(new int[]{1});
    private final Logger logger = LoggerFactory.getLogger(ClusterManagerServerProtocol.class);
    private NodeInformant nodeInformant;
    private String commsIdentifier;
    private boolean shutdown = false;
    private boolean handshakeCompleted = false;
    private long requestExpirationMillis = 30000L;

    public void setNodeInformant(NodeInformant nodeInformant) {
        this.nodeInformant = nodeInformant;
    }

    public void handshake(Peer peer) throws IOException, HandshakeException {
        if (this.handshakeCompleted) {
            throw new IllegalStateException("Handshake has already been completed");
        }
        if (this.shutdown) {
            throw new IllegalStateException("Protocol is shutdown");
        }
        CommunicationsSession commsSession = peer.getCommunicationsSession();
        DataInputStream dis = new DataInputStream(commsSession.getInput().getInputStream());
        DataOutputStream dos = new DataOutputStream(commsSession.getOutput().getOutputStream());
        this.commsIdentifier = dis.readUTF();
        int numProperties = dis.readInt();
        for (int i = 0; i < numProperties; ++i) {
            String propertyName = dis.readUTF();
            String propertyValue = dis.readUTF();
            try {
                HandshakeProperty property = HandshakeProperty.valueOf(propertyName);
                if (!HandshakeProperty.REQUEST_EXPIRATION_MILLIS.equals((Object)property)) continue;
                this.requestExpirationMillis = Long.parseLong(propertyValue);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ResponseCode.PROPERTIES_OK.writeResponse(dos);
        this.logger.debug("Successfully completed handshake with {}; CommsID={}", (Object)peer, (Object)this.commsIdentifier);
        this.handshakeCompleted = true;
    }

    public boolean isHandshakeSuccessful() {
        return this.handshakeCompleted;
    }

    public void sendPeerList(Peer peer) throws IOException {
        if (!this.handshakeCompleted) {
            throw new IllegalStateException("Handshake has not been completed");
        }
        if (this.shutdown) {
            throw new IllegalStateException("Protocol is shutdown");
        }
        CommunicationsSession commsSession = peer.getCommunicationsSession();
        DataOutputStream dos = new DataOutputStream(commsSession.getOutput().getOutputStream());
        ClusterNodeInformation clusterNodeInfo = this.nodeInformant.getNodeInformation();
        Collection nodeInfos = clusterNodeInfo.getNodeInformation();
        int numPeers = 0;
        for (NodeInformation nodeInfo : nodeInfos) {
            if (nodeInfo.getSiteToSitePort() == null) continue;
            ++numPeers;
        }
        dos.writeInt(numPeers);
        for (NodeInformation nodeInfo : nodeInfos) {
            if (nodeInfo.getSiteToSitePort() == null) continue;
            dos.writeUTF(nodeInfo.getHostname());
            dos.writeInt(nodeInfo.getSiteToSitePort());
            dos.writeBoolean(nodeInfo.isSiteToSiteSecure());
            dos.writeInt(nodeInfo.getTotalFlowFiles());
        }
        this.logger.info("Redirected {} to {} nodes", (Object)peer, (Object)numPeers);
        dos.flush();
    }

    public void shutdown(Peer peer) {
        this.shutdown = true;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public FlowFileCodec negotiateCodec(Peer peer) {
        throw new UnsupportedOperationException();
    }

    public FlowFileCodec getPreNegotiatedCodec() {
        return null;
    }

    public RequestType getRequestType(Peer peer) throws IOException {
        CommunicationsSession commsSession = peer.getCommunicationsSession();
        DataInputStream dis = new DataInputStream(commsSession.getInput().getInputStream());
        return RequestType.readRequestType((DataInputStream)dis);
    }

    public int transferFlowFiles(Peer peer, ProcessContext context, ProcessSession session, FlowFileCodec codec) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int receiveFlowFiles(Peer peer, ProcessContext context, ProcessSession session, FlowFileCodec codec) throws IOException {
        throw new UnsupportedOperationException();
    }

    public VersionNegotiator getVersionNegotiator() {
        return this.versionNegotiator;
    }

    public String getResourceName() {
        return RESOURCE_NAME;
    }

    public void setRootProcessGroup(ProcessGroup rootGroup) {
    }

    public RootGroupPort getPort() {
        return null;
    }

    public long getRequestExpiration() {
        return this.requestExpirationMillis;
    }
}

