/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.socket.ssl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.remote.io.socket.ssl.SSLSocketChannel;
import org.apache.nifi.remote.io.socket.ssl.SSLSocketChannelInputStream;
import org.apache.nifi.remote.protocol.CommunicationsInput;
import org.apache.nifi.stream.io.BufferedInputStream;
import org.apache.nifi.stream.io.ByteCountingInputStream;

public class SSLSocketChannelInput
implements CommunicationsInput {
    private final SSLSocketChannelInputStream in;
    private final ByteCountingInputStream countingIn;
    private final InputStream bufferedIn;

    public SSLSocketChannelInput(SSLSocketChannel socketChannel) {
        this.in = new SSLSocketChannelInputStream(socketChannel);
        this.countingIn = new ByteCountingInputStream((InputStream)this.in);
        this.bufferedIn = new BufferedInputStream((InputStream)this.countingIn);
    }

    public InputStream getInputStream() throws IOException {
        return this.bufferedIn;
    }

    public boolean isDataAvailable() throws IOException {
        return this.bufferedIn.available() > 0;
    }

    public long getBytesRead() {
        return this.countingIn.getBytesRead();
    }
}

