/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.io.socket.ssl;

import java.io.IOException;
import org.apache.nifi.remote.AbstractCommunicationsSession;
import org.apache.nifi.remote.io.socket.ssl.SSLSocketChannel;
import org.apache.nifi.remote.io.socket.ssl.SSLSocketChannelInput;
import org.apache.nifi.remote.io.socket.ssl.SSLSocketChannelOutput;

public class SSLSocketChannelCommunicationsSession
extends AbstractCommunicationsSession {
    private final SSLSocketChannel channel;
    private final SSLSocketChannelInput request;
    private final SSLSocketChannelOutput response;

    public SSLSocketChannelCommunicationsSession(SSLSocketChannel channel, String uri) {
        super(uri);
        this.request = new SSLSocketChannelInput(channel);
        this.response = new SSLSocketChannelOutput(channel);
        this.channel = channel;
    }

    public SSLSocketChannelInput getInput() {
        return this.request;
    }

    public SSLSocketChannelOutput getOutput() {
        return this.response;
    }

    public void setTimeout(int millis) throws IOException {
        this.channel.setTimeout(millis);
    }

    public int getTimeout() throws IOException {
        return this.channel.getTimeout();
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public boolean isClosed() {
        return this.channel.isClosed();
    }

    public boolean isDataAvailable() {
        try {
            return this.request.isDataAvailable();
        }
        catch (Exception e) {
            return false;
        }
    }

    public long getBytesWritten() {
        return this.response.getBytesWritten();
    }

    public long getBytesRead() {
        return this.request.getBytesRead();
    }

    public void interrupt() {
        this.channel.interrupt();
    }

    @Override
    public String toString() {
        return super.toString() + "[SSLSocketChannel=" + this.channel + "]";
    }
}

