/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.codec;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.io.InputStreamCallback;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.remote.StandardVersionNegotiator;
import org.apache.nifi.remote.VersionNegotiator;
import org.apache.nifi.remote.codec.FlowFileCodec;
import org.apache.nifi.remote.exception.ProtocolException;
import org.apache.nifi.stream.io.StreamUtils;

public class StandardFlowFileCodec
implements FlowFileCodec {
    public static final int MAX_NUM_ATTRIBUTES = 25000;
    public static final String DEFAULT_FLOWFILE_PATH = "./";
    private final VersionNegotiator versionNegotiator = new StandardVersionNegotiator(new int[]{1});

    public FlowFile encode(FlowFile flowFile, ProcessSession session, final OutputStream encodedOut) throws IOException {
        DataOutputStream out = new DataOutputStream(encodedOut);
        Map attributes = flowFile.getAttributes();
        out.writeInt(attributes.size());
        for (Map.Entry entry : attributes.entrySet()) {
            this.writeString((String)entry.getKey(), out);
            this.writeString((String)entry.getValue(), out);
        }
        out.writeLong(flowFile.getSize());
        session.read(flowFile, new InputStreamCallback(){

            public void process(InputStream in) throws IOException {
                int len;
                byte[] buffer = new byte[8192];
                while ((len = in.read(buffer)) > 0) {
                    encodedOut.write(buffer, 0, len);
                }
                encodedOut.flush();
            }
        });
        return flowFile;
    }

    public FlowFile decode(InputStream stream, ProcessSession session) throws IOException, ProtocolException {
        int numAttributes;
        final DataInputStream in = new DataInputStream(stream);
        try {
            numAttributes = in.readInt();
        }
        catch (EOFException e) {
            return null;
        }
        if (numAttributes > 25000) {
            throw new ProtocolException("FlowFile exceeds maximum number of attributes with a total of " + numAttributes);
        }
        try {
            HashMap<String, String> attributes = new HashMap<String, String>(numAttributes);
            for (int i = 0; i < numAttributes; ++i) {
                String attrName = this.readString(in);
                String attrValue = this.readString(in);
                attributes.put(attrName, attrValue);
            }
            final long numBytes = in.readLong();
            FlowFile flowFile = session.create();
            flowFile = session.putAllAttributes(flowFile, attributes);
            flowFile = session.write(flowFile, new OutputStreamCallback(){

                public void process(OutputStream out) throws IOException {
                    long size;
                    int len;
                    byte[] buffer = new byte[8192];
                    for (size = 0L; size < numBytes && (len = in.read(buffer, 0, (int)Math.min((long)buffer.length, numBytes - size))) > 0; size += (long)len) {
                        out.write(buffer, 0, len);
                    }
                    if (size != numBytes) {
                        throw new EOFException("Expected " + numBytes + " bytes but received only " + size);
                    }
                }
            });
            return flowFile;
        }
        catch (EOFException e) {
            session.rollback();
            throw e;
        }
    }

    private void writeString(String val, DataOutputStream out) throws IOException {
        byte[] bytes = val.getBytes("UTF-8");
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    private String readString(DataInputStream in) throws IOException {
        int numBytes = in.readInt();
        byte[] bytes = new byte[numBytes];
        StreamUtils.fillBuffer((InputStream)in, (byte[])bytes, (boolean)true);
        return new String(bytes, "UTF-8");
    }

    public List<Integer> getSupportedVersions() {
        return this.versionNegotiator.getSupportedVersions();
    }

    public VersionNegotiator getVersionNegotiator() {
        return this.versionNegotiator;
    }

    public String toString() {
        return "Standard FlowFile Codec, Version " + this.versionNegotiator.getVersion();
    }

    public String getResourceName() {
        return "StandardFlowFileCodec";
    }
}

