/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellRunner {
    private static final Logger logger = LoggerFactory.getLogger(ShellRunner.class);
    static String SHELL = "sh";
    static String OPTS = "-c";
    private final int timeoutSeconds;
    private final ExecutorService executor;

    public ShellRunner(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        this.executor = Executors.newFixedThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName("ShellRunner");
                t.setDaemon(true);
                return t;
            }
        });
    }

    public List<String> runShell(String command) throws IOException {
        return this.runShell(command, "<unknown>");
    }

    public List<String> runShell(String command, String description) throws IOException {
        boolean completed;
        ProcessBuilder builder = new ProcessBuilder(SHELL, OPTS, command);
        builder.redirectErrorStream(true);
        List<String> builderCommand = builder.command();
        logger.debug("Run Command '{}': {}", new Object[]{description, builderCommand});
        Process proc = builder.start();
        ArrayList<String> lines = new ArrayList<String>();
        this.executor.submit(() -> {
            try (InputStreamReader stdin = new InputStreamReader(proc.getInputStream());
                 BufferedReader reader = new BufferedReader(stdin);){
                String line;
                logger.trace("Reading process input stream...");
                int lineCount = 0;
                while ((line = reader.readLine()) != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace(++lineCount + " - " + line);
                    }
                    lines.add(line.trim());
                }
                logger.trace("Finished reading process input stream");
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        });
        try {
            completed = proc.waitFor(this.timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException irexc) {
            throw new IOException(irexc.getMessage(), irexc.getCause());
        }
        if (!completed) {
            logger.debug("Process did not complete in allotted time, attempting to forcibly destroy process...");
            try {
                proc.destroyForcibly();
            }
            catch (Exception e) {
                logger.debug("Process failed to destroy: " + e.getMessage(), (Throwable)e);
            }
            throw new IllegalStateException("Shell command '" + command + "' did not complete during the allotted time period");
        }
        if (proc.exitValue() != 0) {
            throw new IOException("Process exited with non-zero value: " + proc.exitValue());
        }
        return lines;
    }

    public void shutdown() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(5000L, TimeUnit.MILLISECONDS)) {
                logger.info("Failed to stop ShellRunner executor in 5 seconds. Terminating");
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

