/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parquet.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.parquet.stream.NifiParquetOutputFile;
import org.apache.nifi.parquet.utils.ParquetConfig;
import org.apache.nifi.parquet.utils.ParquetUtils;
import org.apache.nifi.serialization.AbstractRecordSetWriter;
import org.apache.nifi.serialization.record.Record;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.io.OutputFile;

public class WriteParquetResult
extends AbstractRecordSetWriter {
    private final Schema schema;
    private final ParquetWriter<GenericRecord> parquetWriter;
    private final ComponentLog componentLogger;

    public WriteParquetResult(Schema schema, OutputStream out, ParquetConfig parquetConfig, ComponentLog componentLogger) throws IOException {
        super(out);
        this.schema = schema;
        this.componentLogger = componentLogger;
        Configuration conf = new Configuration();
        NifiParquetOutputFile outputFile = new NifiParquetOutputFile(out);
        AvroParquetWriter.Builder writerBuilder = AvroParquetWriter.builder((OutputFile)outputFile).withSchema(schema);
        ParquetUtils.applyCommonConfig(writerBuilder, conf, parquetConfig);
        this.parquetWriter = writerBuilder.build();
    }

    protected Map<String, String> writeRecord(Record record) throws IOException {
        GenericRecord genericRecord = AvroTypeUtil.createAvroRecord((Record)record, (Schema)this.schema);
        this.parquetWriter.write((Object)genericRecord);
        return Collections.emptyMap();
    }

    public void close() throws IOException {
        try {
            this.parquetWriter.close();
        }
        finally {
            super.close();
        }
    }

    public String getMimeType() {
        return "application/parquet";
    }
}

