/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parquet;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.parquet.record.WriteParquetResult;
import org.apache.nifi.parquet.utils.ParquetConfig;
import org.apache.nifi.parquet.utils.ParquetUtils;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.RecordSetWriter;
import org.apache.nifi.serialization.RecordSetWriterFactory;
import org.apache.nifi.serialization.SchemaRegistryRecordSetWriter;
import org.apache.nifi.serialization.record.RecordSchema;

@Tags(value={"parquet", "result", "set", "writer", "serializer", "record", "recordset", "row"})
@CapabilityDescription(value="Writes the contents of a RecordSet in Parquet format.")
public class ParquetRecordSetWriter
extends SchemaRegistryRecordSetWriter
implements RecordSetWriterFactory {
    public static final PropertyDescriptor CACHE_SIZE = new PropertyDescriptor.Builder().name("cache-size").displayName("Cache Size").description("Specifies how many Schemas should be cached").addValidator(StandardValidators.NON_NEGATIVE_INTEGER_VALIDATOR).defaultValue("1000").required(true).build();
    public static final PropertyDescriptor INT96_FIELDS = new PropertyDescriptor.Builder().name("int96-fields").displayName("INT96 Fields").description("List of fields with full path that should be treated as INT96 timestamps.").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(false).build();
    private LoadingCache<String, Schema> compiledAvroSchemaCache;
    private String int96Fields;

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        int cacheSize = context.getProperty(CACHE_SIZE).asInteger();
        this.compiledAvroSchemaCache = Caffeine.newBuilder().maximumSize((long)cacheSize).build(schemaText -> new Schema.Parser().parse(schemaText));
        this.int96Fields = context.getProperty(INT96_FIELDS).isSet() ? context.getProperty(INT96_FIELDS).getValue() : null;
    }

    public RecordSetWriter createWriter(ComponentLog logger, RecordSchema recordSchema, OutputStream out, Map<String, String> variables) throws IOException {
        ParquetConfig parquetConfig = ParquetUtils.createParquetConfig((PropertyContext)this.getConfigurationContext(), variables);
        parquetConfig.setInt96Fields(this.int96Fields);
        try {
            Schema avroSchema;
            try {
                Optional textOption;
                avroSchema = recordSchema.getSchemaFormat().isPresent() && ((String)recordSchema.getSchemaFormat().get()).equals("avro") ? ((textOption = recordSchema.getSchemaText()).isPresent() ? (Schema)this.compiledAvroSchemaCache.get(textOption.get()) : AvroTypeUtil.extractAvroSchema((RecordSchema)recordSchema)) : AvroTypeUtil.extractAvroSchema((RecordSchema)recordSchema);
            }
            catch (Exception e) {
                throw new SchemaNotFoundException("Failed to compile Avro Schema", (Throwable)e);
            }
            return new WriteParquetResult(avroSchema, out, parquetConfig, logger);
        }
        catch (SchemaNotFoundException e) {
            throw new ProcessException("Could not determine the Avro Schema to use for writing the content", (Throwable)e);
        }
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(super.getSupportedPropertyDescriptors());
        properties.add(CACHE_SIZE);
        properties.add(ParquetUtils.COMPRESSION_TYPE);
        properties.add(ParquetUtils.ROW_GROUP_SIZE);
        properties.add(ParquetUtils.PAGE_SIZE);
        properties.add(ParquetUtils.DICTIONARY_PAGE_SIZE);
        properties.add(ParquetUtils.MAX_PADDING_SIZE);
        properties.add(ParquetUtils.ENABLE_DICTIONARY_ENCODING);
        properties.add(ParquetUtils.ENABLE_VALIDATION);
        properties.add(ParquetUtils.WRITER_VERSION);
        properties.add(ParquetUtils.AVRO_WRITE_OLD_LIST_STRUCTURE);
        properties.add(ParquetUtils.AVRO_ADD_LIST_ELEMENT_RECORDS);
        properties.add(INT96_FIELDS);
        return properties;
    }
}

