/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.extension.definition.extraction;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.maven.artifact.Artifact;

public class ExtensionClassLoader
extends URLClassLoader {
    private final URL[] urls;
    private final Artifact narArtifact;
    private final Collection<Artifact> allArtifacts;

    public ExtensionClassLoader(URL[] urls, ClassLoader parent, Artifact narArtifact, Collection<Artifact> otherArtifacts) {
        super(urls, parent);
        this.urls = urls;
        this.narArtifact = narArtifact;
        this.allArtifacts = new ArrayList<Artifact>(otherArtifacts);
        if (narArtifact != null) {
            this.allArtifacts.add(narArtifact);
        }
    }

    public ExtensionClassLoader(URL[] urls, Artifact narArtifact, Collection<Artifact> otherArtifacts) {
        super(urls);
        this.urls = urls;
        this.narArtifact = narArtifact;
        this.allArtifacts = new ArrayList<Artifact>(otherArtifacts);
        if (narArtifact != null) {
            this.allArtifacts.add(narArtifact);
        }
    }

    public String getNiFiApiVersion() {
        Collection<Artifact> artifacts = this.getAllArtifacts();
        for (Artifact artifact : artifacts) {
            if (!artifact.getArtifactId().equals("nifi-api") || !artifact.getGroupId().equals("org.apache.nifi")) continue;
            return artifact.getVersion();
        }
        ClassLoader parent = this.getParent();
        if (parent instanceof ExtensionClassLoader) {
            return ((ExtensionClassLoader)parent).getNiFiApiVersion();
        }
        return null;
    }

    public Artifact getNarArtifact() {
        return this.narArtifact;
    }

    public Collection<Artifact> getAllArtifacts() {
        return this.allArtifacts;
    }

    public String toString() {
        return "ExtensionClassLoader[" + this.narArtifact + ", Dependencies=" + Arrays.asList(this.urls) + "]";
    }

    public String toTree() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClassLoader for ").append(this.narArtifact).append(" with nifi-api version ").append(this.getNiFiApiVersion()).append(":\n");
        for (URL url : this.urls) {
            sb.append(url).append("\n");
        }
        ClassLoader parent = this.getParent();
        if (parent instanceof ExtensionClassLoader) {
            sb.append("\n\n-------- Parent:\n");
            sb.append(((ExtensionClassLoader)parent).toTree());
        } else if (parent instanceof URLClassLoader) {
            sb.append(this.toTree((URLClassLoader)parent));
        }
        return sb.toString();
    }

    private String toTree(URLClassLoader classLoader) {
        URL[] urls;
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n-------- Parent:\n");
        for (URL url : urls = classLoader.getURLs()) {
            sb.append(url).append("\n");
        }
        ClassLoader parent = classLoader.getParent();
        if (parent instanceof URLClassLoader) {
            URLClassLoader urlParent = (URLClassLoader)parent;
            sb.append(this.toTree(urlParent));
        }
        return sb.toString();
    }
}

