/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.server.log;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.web.security.log.AuthenticationUserAttribute;
import org.apache.nifi.web.server.log.UserPrincipal;
import org.eclipse.jetty.security.DefaultUserIdentity;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class RequestAuthenticationFilter
extends OncePerRequestFilter {
    private static final Subject DEFAULT_SUBJECT = new Subject();
    private static final String[] DEFAULT_ROLES = new String[0];
    private static final String METHOD = "FILTER";
    private static final Logger logger = LoggerFactory.getLogger(RequestAuthenticationFilter.class);

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        if (httpServletRequest instanceof Request) {
            Request request = (Request)httpServletRequest;
            Object usernameAttribute = httpServletRequest.getAttribute(AuthenticationUserAttribute.USERNAME.getName());
            if (usernameAttribute == null) {
                logger.debug("Username not found Remote Address [{}]", (Object)httpServletRequest.getRemoteAddr());
            } else {
                String username = usernameAttribute.toString();
                UserPrincipal principal = new UserPrincipal(username);
                DefaultUserIdentity userIdentity = new DefaultUserIdentity(DEFAULT_SUBJECT, (Principal)principal, DEFAULT_ROLES);
                UserAuthentication authentication = new UserAuthentication(METHOD, (UserIdentity)userIdentity);
                request.setAuthentication((Authentication)authentication);
            }
        }
    }
}

