/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.server.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.headers.ContentSecurityPolicyFilter;
import org.apache.nifi.web.security.headers.StrictTransportSecurityFilter;
import org.apache.nifi.web.security.headers.XContentTypeOptionsFilter;
import org.apache.nifi.web.security.headers.XFrameOptionsFilter;
import org.apache.nifi.web.security.headers.XSSProtectionFilter;
import org.apache.nifi.web.security.requests.ContentLengthFilter;
import org.apache.nifi.web.server.filter.DataTransferExcludedDoSFilter;
import org.apache.nifi.web.server.filter.RequestFilterProvider;
import org.apache.nifi.web.server.log.RequestAuthenticationFilter;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlets.DoSFilter;

public class StandardRequestFilterProvider
implements RequestFilterProvider {
    private static final int MAX_CONTENT_SIZE_DISABLED = 0;

    @Override
    public List<FilterHolder> getFilters(NiFiProperties properties) {
        int maxContentSize;
        Objects.requireNonNull(properties, "Properties required");
        ArrayList<FilterHolder> filters = new ArrayList<FilterHolder>();
        filters.add(this.getFilterHolder(XFrameOptionsFilter.class));
        filters.add(this.getFilterHolder(ContentSecurityPolicyFilter.class));
        filters.add(this.getFilterHolder(XSSProtectionFilter.class));
        filters.add(this.getFilterHolder(XContentTypeOptionsFilter.class));
        if (properties.isHTTPSConfigured()) {
            filters.add(this.getFilterHolder(StrictTransportSecurityFilter.class));
            filters.add(this.getFilterHolder(RequestAuthenticationFilter.class));
        }
        if ((maxContentSize = this.getMaxContentSize(properties)) > 0) {
            FilterHolder contentLengthFilter = this.getContentLengthFilter(maxContentSize);
            filters.add(contentLengthFilter);
        }
        FilterHolder denialOfServiceFilter = this.getDenialOfServiceFilter(properties, DataTransferExcludedDoSFilter.class);
        filters.add(denialOfServiceFilter);
        return filters;
    }

    protected FilterHolder getDenialOfServiceFilter(NiFiProperties properties, Class<? extends DoSFilter> filterClass) {
        FilterHolder filter = new FilterHolder(filterClass);
        int maxWebRequestsPerSecond = properties.getMaxWebRequestsPerSecond();
        filter.setInitParameter("maxRequestsPerSec", Integer.toString(maxWebRequestsPerSecond));
        long webRequestTimeout = this.getWebRequestTimeout(properties);
        filter.setInitParameter("maxRequestMs", Long.toString(webRequestTimeout));
        String webRequestIpWhitelist = properties.getWebRequestIpWhitelist();
        filter.setInitParameter("ipWhitelist", webRequestIpWhitelist);
        filter.setName(DoSFilter.class.getSimpleName());
        return filter;
    }

    private FilterHolder getFilterHolder(Class<? extends Filter> filterClass) {
        FilterHolder filter = new FilterHolder(filterClass);
        filter.setName(filterClass.getSimpleName());
        return filter;
    }

    private FilterHolder getContentLengthFilter(int maxContentSize) {
        FilterHolder filter = new FilterHolder(ContentLengthFilter.class);
        filter.setInitParameter("maxContentLength", Integer.toString(maxContentSize));
        filter.setName(ContentLengthFilter.class.getSimpleName());
        return filter;
    }

    private int getMaxContentSize(NiFiProperties properties) {
        String webMaxContentSize = properties.getWebMaxContentSize();
        try {
            return StringUtils.isBlank((CharSequence)webMaxContentSize) ? 0 : DataUnit.parseDataSize((String)webMaxContentSize, (DataUnit)DataUnit.B).intValue();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(String.format("Property [%s] format invalid", "nifi.web.max.content.size"), e);
        }
    }

    protected long getWebRequestTimeout(NiFiProperties properties) {
        String webRequestTimeout = properties.getWebRequestTimeout();
        try {
            double webRequestTimeoutParsed = FormatUtils.getPreciseTimeDuration((String)webRequestTimeout, (TimeUnit)TimeUnit.MILLISECONDS);
            return Math.round(webRequestTimeoutParsed);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(String.format("Property [%s] format invalid", "nifi.web.request.timeout"), e);
        }
    }
}

