/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.hadoop;

import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.io.OutputStreamCallback;
import org.apache.nifi.processors.hadoop.util.OutputStreamWritable;
import org.apache.nifi.processors.hadoop.util.SequenceFileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueReader
implements SequenceFileReader<Set<FlowFile>> {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueReader.class);
    private final ProcessSession session;
    private static final Pattern LOOKS_LIKE_FILENAME = Pattern.compile("^[\\w/].*");

    public KeyValueReader(ProcessSession session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<FlowFile> readSequenceFile(Path file, Configuration configuration, FileSystem fileSystem) throws IOException {
        HashSet<FlowFile> flowFiles = new HashSet<FlowFile>();
        SequenceFile.Reader reader = new SequenceFile.Reader(configuration, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)fileSystem.makeQualified(file))});
        Text key = new Text();
        KeyValueWriterCallback callback = new KeyValueWriterCallback(reader);
        String inputfileName = file.getName() + "." + System.nanoTime() + ".";
        int counter = 0;
        LOG.debug("Read from SequenceFile: {} ", new Object[]{file});
        try {
            while (reader.next((Writable)key)) {
                String fileName = key.toString();
                if (LOOKS_LIKE_FILENAME.matcher(fileName).matches()) {
                    if (fileName.contains(File.separator)) {
                        fileName = StringUtils.substringAfterLast((String)fileName, (String)File.separator);
                    }
                    fileName = fileName + "." + System.nanoTime();
                } else {
                    fileName = inputfileName + ++counter;
                }
                FlowFile flowFile = this.session.create();
                flowFile = this.session.putAttribute(flowFile, CoreAttributes.FILENAME.key(), fileName);
                callback.key = key;
                try {
                    flowFile = this.session.write(flowFile, (OutputStreamCallback)callback);
                    flowFiles.add(flowFile);
                }
                catch (ProcessException e) {
                    LOG.error("Could not write to flowfile {}", (Object)new Object[]{flowFile}, (Object)e);
                    this.session.remove(flowFile);
                }
                key.clear();
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)reader);
        }
        return flowFiles;
    }

    static class KeyValueWriterCallback
    implements OutputStreamCallback {
        Text key;
        private final SequenceFile.Reader reader;

        public KeyValueWriterCallback(SequenceFile.Reader reader) {
            this.reader = reader;
        }

        public void process(OutputStream out) throws IOException {
            DataOutputStream dos = new DataOutputStream(out);
            dos.writeInt(this.key.getLength());
            dos.write(this.key.getBytes(), 0, this.key.getLength());
            OutputStreamWritable fileData = new OutputStreamWritable(out, true);
            this.reader.getCurrentValue((Writable)fileData);
        }
    }
}

