/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.org.h2.table;

import org.apache.nifi.org.h2.command.dml.DataChangeStatement;
import org.apache.nifi.org.h2.engine.Session;
import org.apache.nifi.org.h2.expression.Expression;
import org.apache.nifi.org.h2.expression.ExpressionColumn;
import org.apache.nifi.org.h2.result.LocalResult;
import org.apache.nifi.org.h2.result.ResultInterface;
import org.apache.nifi.org.h2.schema.Schema;
import org.apache.nifi.org.h2.table.Column;
import org.apache.nifi.org.h2.table.Table;
import org.apache.nifi.org.h2.table.VirtualConstructedTable;

public class DataChangeDeltaTable
extends VirtualConstructedTable {
    private final DataChangeStatement statement;
    private final ResultOption resultOption;
    private final Expression[] expressions;

    public DataChangeDeltaTable(Schema schema, Session session, DataChangeStatement dataChangeStatement, ResultOption resultOption) {
        super(schema, 0, dataChangeStatement.getStatementName());
        this.statement = dataChangeStatement;
        this.resultOption = resultOption;
        Table table = dataChangeStatement.getTable();
        Column[] columnArray = table.getColumns();
        this.setColumns(columnArray);
        int n = columnArray.length;
        Expression[] expressionArray = new Expression[n];
        String string = this.getName();
        for (int i = 0; i < n; ++i) {
            expressionArray[i] = new ExpressionColumn(this.database, null, string, columnArray[i].getName(), false);
        }
        this.expressions = expressionArray;
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public long getRowCount(Session session) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getRowCountApproximation() {
        return Long.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultInterface getResult(Session session) {
        this.statement.prepare();
        int n = this.expressions.length;
        LocalResult localResult = session.getDatabase().getResultFactory().create(session, this.expressions, n, n);
        try {
            this.statement.setDeltaChangeCollector(localResult, this.resultOption);
            this.statement.update();
        }
        finally {
            this.statement.setDeltaChangeCollector(null, null);
        }
        return localResult;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        return stringBuilder.append(this.resultOption.name()).append(" TABLE (").append(this.statement.getSQL()).append(')');
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    public static enum ResultOption {
        OLD,
        NEW,
        FINAL;

    }
}

