/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.org.h2.mode;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.nifi.org.h2.engine.Database;
import org.apache.nifi.org.h2.engine.Session;
import org.apache.nifi.org.h2.expression.Expression;
import org.apache.nifi.org.h2.expression.ValueExpression;
import org.apache.nifi.org.h2.expression.function.Function;
import org.apache.nifi.org.h2.expression.function.FunctionInfo;
import org.apache.nifi.org.h2.message.DbException;
import org.apache.nifi.org.h2.mode.FunctionsBase;
import org.apache.nifi.org.h2.util.DateTimeUtils;
import org.apache.nifi.org.h2.util.StringUtils;
import org.apache.nifi.org.h2.value.TypeInfo;
import org.apache.nifi.org.h2.value.Value;
import org.apache.nifi.org.h2.value.ValueInt;
import org.apache.nifi.org.h2.value.ValueLong;
import org.apache.nifi.org.h2.value.ValueNull;
import org.apache.nifi.org.h2.value.ValueString;
import org.apache.nifi.org.h2.value.ValueTimestamp;
import org.apache.nifi.org.h2.value.ValueTimestampTimeZone;

public class FunctionsMySQL
extends FunctionsBase {
    private static final int UNIX_TIMESTAMP = 1001;
    private static final int FROM_UNIXTIME = 1002;
    private static final int DATE = 1003;
    private static final int LAST_INSERT_ID = 1004;
    private static final HashMap<String, FunctionInfo> FUNCTIONS = new HashMap();
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String[] FORMAT_REPLACE;

    public static int unixTimestamp(Value value) {
        long l;
        if (value instanceof ValueTimestampTimeZone) {
            ValueTimestampTimeZone valueTimestampTimeZone = (ValueTimestampTimeZone)value;
            long l2 = valueTimestampTimeZone.getTimeNanos();
            l = DateTimeUtils.absoluteDayFromDateValue(valueTimestampTimeZone.getDateValue()) * 86400L + l2 / 1000000000L - (long)valueTimestampTimeZone.getTimeZoneOffsetSeconds();
        } else {
            ValueTimestamp valueTimestamp = (ValueTimestamp)value.convertTo(11);
            long l3 = valueTimestamp.getTimeNanos();
            l = DateTimeUtils.getTimeZone().getEpochSecondsFromLocal(valueTimestamp.getDateValue(), l3);
        }
        return (int)l;
    }

    public static String fromUnixTime(int n) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_TIME_FORMAT, Locale.ENGLISH);
        return simpleDateFormat.format(new Date((long)n * 1000L));
    }

    public static String fromUnixTime(int n, String string) {
        string = FunctionsMySQL.convertToSimpleDateFormat(string);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.ENGLISH);
        return simpleDateFormat.format(new Date((long)n * 1000L));
    }

    private static String convertToSimpleDateFormat(String string) {
        String[] stringArray = FORMAT_REPLACE;
        for (int i = 0; i < stringArray.length; i += 2) {
            string = StringUtils.replaceAll(string, stringArray[i], stringArray[i + 1]);
        }
        return string;
    }

    public static Function getFunction(Database database, String string) {
        FunctionInfo functionInfo = FUNCTIONS.get(string);
        return functionInfo != null ? new FunctionsMySQL(database, functionInfo) : null;
    }

    FunctionsMySQL(Database database, FunctionInfo functionInfo) {
        super(database, functionInfo);
    }

    @Override
    protected void checkParameterCount(int n) {
        int n2;
        int n3;
        switch (this.info.type) {
            case 1001: {
                n3 = 0;
                n2 = 1;
                break;
            }
            case 1002: {
                n3 = 1;
                n2 = 2;
                break;
            }
            case 1003: {
                n3 = 1;
                n2 = 1;
                break;
            }
            case 1004: {
                n3 = 0;
                n2 = 1;
                break;
            }
            default: {
                DbException.throwInternalError("type=" + this.info.type);
                return;
            }
        }
        if (n < n3 || n > n2) {
            throw DbException.get(7001, this.info.name, n3 + ".." + n2);
        }
    }

    @Override
    public Expression optimize(Session session) {
        boolean bl = this.info.deterministic;
        for (int i = 0; i < this.args.length; ++i) {
            Expression expression = this.args[i];
            if (expression == null) continue;
            this.args[i] = expression = expression.optimize(session);
            if (expression.isConstant()) continue;
            bl = false;
        }
        if (bl) {
            return ValueExpression.get(this.getValue(session));
        }
        this.type = TypeInfo.getTypeInfo(this.info.returnDataType);
        return this;
    }

    @Override
    protected Value getValueWithArgs(Session session, Expression[] expressionArray) {
        Value value;
        Value[] valueArray = new Value[expressionArray.length];
        Value value2 = FunctionsMySQL.getNullOrValue(session, expressionArray, valueArray, 0);
        Value value3 = FunctionsMySQL.getNullOrValue(session, expressionArray, valueArray, 1);
        block1 : switch (this.info.type) {
            case 1001: {
                value = ValueInt.get(FunctionsMySQL.unixTimestamp(value2 == null ? session.currentTimestamp() : value2));
                break;
            }
            case 1002: {
                value = ValueString.get(value3 == null ? FunctionsMySQL.fromUnixTime(value2.getInt()) : FunctionsMySQL.fromUnixTime(value2.getInt(), value3.getString()));
                break;
            }
            case 1003: {
                switch (value2.getValueType()) {
                    case 10: {
                        value = value2;
                        break block1;
                    }
                    default: {
                        try {
                            value2 = value2.convertTo(11, session, false);
                            break;
                        }
                        catch (DbException dbException) {
                            value2 = ValueNull.INSTANCE;
                        }
                    }
                    case 11: 
                    case 24: 
                }
                value = value2.convertTo(10);
                break;
            }
            case 1004: {
                if (expressionArray.length == 0) {
                    value = session.getLastIdentity();
                    break;
                }
                if (value2 == ValueNull.INSTANCE) {
                    session.setLastIdentity(ValueLong.get(0L));
                    value = value2;
                    break;
                }
                value = value2.convertTo(5);
                session.setLastIdentity(value);
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + this.info.type);
            }
        }
        return value;
    }

    static {
        FUNCTIONS.put("UNIX_TIMESTAMP", new FunctionInfo("UNIX_TIMESTAMP", 1001, -1, 4, false, false, true, false));
        FUNCTIONS.put("FROM_UNIXTIME", new FunctionInfo("FROM_UNIXTIME", 1002, -1, 13, false, true, true, false));
        FUNCTIONS.put("DATE", new FunctionInfo("DATE", 1003, 1, 10, false, true, true, false));
        FUNCTIONS.put("LAST_INSERT_ID", new FunctionInfo("LAST_INSERT_ID", 1004, -1, 5, false, false, true, false));
        FORMAT_REPLACE = new String[]{"%a", "EEE", "%b", "MMM", "%c", "MM", "%d", "dd", "%e", "d", "%H", "HH", "%h", "hh", "%I", "hh", "%i", "mm", "%j", "DDD", "%k", "H", "%l", "h", "%M", "MMMM", "%m", "MM", "%p", "a", "%r", "hh:mm:ss a", "%S", "ss", "%s", "ss", "%T", "HH:mm:ss", "%W", "EEEE", "%w", "F", "%Y", "yyyy", "%y", "yy", "%%", "%"};
    }
}

