/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileChannelInputStream
extends InputStream {
    private final FileChannel channel;
    private final boolean closeChannel;
    private ByteBuffer buffer;
    private long pos;

    public FileChannelInputStream(FileChannel fileChannel, boolean bl) {
        this.channel = fileChannel;
        this.closeChannel = bl;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer == null) {
            this.buffer = ByteBuffer.allocate(1);
        }
        this.buffer.rewind();
        int n = this.channel.read(this.buffer, this.pos++);
        if (n < 0) {
            return -1;
        }
        return this.buffer.get(0) & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        int n3 = this.channel.read(byteBuffer, this.pos);
        if (n3 == -1) {
            return -1;
        }
        this.pos += (long)n3;
        return n3;
    }

    @Override
    public void close() throws IOException {
        if (this.closeChannel) {
            this.channel.close();
        }
    }
}

