/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.nifi.cluster.protocol.impl.ClusterServiceDiscovery;
import org.apache.nifi.io.socket.multicast.DiscoverableService;
import org.apache.nifi.io.socket.multicast.DiscoverableServiceImpl;
import org.apache.nifi.io.socket.multicast.ServiceDiscovery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterServiceLocator
implements ServiceDiscovery {
    private static final Logger logger = LoggerFactory.getLogger(ClusterServiceLocator.class);
    private final String serviceName;
    private final ClusterServiceDiscovery serviceDiscovery;
    private final DiscoverableService fixedService;
    private final int fixedServicePort;
    private final AttemptsConfig attemptsConfig = new AttemptsConfig();
    private final AtomicBoolean running = new AtomicBoolean(false);

    public ClusterServiceLocator(ClusterServiceDiscovery serviceDiscovery) {
        if (serviceDiscovery == null) {
            throw new IllegalArgumentException("ClusterServiceDiscovery may not be null.");
        }
        this.serviceDiscovery = serviceDiscovery;
        this.fixedService = null;
        this.fixedServicePort = 0;
        this.serviceName = serviceDiscovery.getServiceName();
    }

    public ClusterServiceLocator(ClusterServiceDiscovery serviceDiscovery, int fixedServicePort) {
        if (serviceDiscovery == null) {
            throw new IllegalArgumentException("ClusterServiceDiscovery may not be null.");
        }
        this.serviceDiscovery = serviceDiscovery;
        this.fixedService = null;
        this.fixedServicePort = fixedServicePort;
        this.serviceName = serviceDiscovery.getServiceName();
    }

    public ClusterServiceLocator(DiscoverableService fixedService) {
        if (fixedService == null) {
            throw new IllegalArgumentException("Service may not be null.");
        }
        this.serviceDiscovery = null;
        this.fixedService = fixedService;
        this.fixedServicePort = 0;
        this.serviceName = fixedService.getServiceName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoverableService getService() {
        int secondsBetweenAttempts;
        int numAttemptsValue;
        ClusterServiceLocator clusterServiceLocator = this;
        synchronized (clusterServiceLocator) {
            numAttemptsValue = this.attemptsConfig.numAttempts;
            secondsBetweenAttempts = this.attemptsConfig.getTimeBetweenAttempts();
        }
        for (int i = 0; i < numAttemptsValue; ++i) {
            DiscoverableService discoveredService;
            if (this.fixedService != null) {
                return this.fixedService;
            }
            if (this.serviceDiscovery != null && (discoveredService = this.serviceDiscovery.getService()) != null) {
                if (this.fixedServicePort > 0) {
                    InetSocketAddress addr = InetSocketAddress.createUnresolved(discoveredService.getServiceAddress().getHostName(), this.fixedServicePort);
                    DiscoverableServiceImpl result = new DiscoverableServiceImpl(discoveredService.getServiceName(), addr);
                    return result;
                }
                return discoveredService;
            }
            try {
                logger.debug(String.format("Locating Cluster Service '%s' Attempt: %d of %d failed.  Trying again in %d seconds.", this.serviceName, i + 1, numAttemptsValue, secondsBetweenAttempts));
                Thread.sleep(secondsBetweenAttempts * 1000);
                continue;
            }
            catch (InterruptedException ie) {
                break;
            }
        }
        return null;
    }

    public boolean isRunning() {
        if (this.serviceDiscovery != null) {
            return this.serviceDiscovery.isRunning();
        }
        return this.running.get();
    }

    public void start() throws IOException {
        if (this.isRunning()) {
            throw new IllegalStateException("Instance is already started.");
        }
        if (this.serviceDiscovery != null) {
            this.serviceDiscovery.start();
        }
        this.running.set(true);
    }

    public void stop() throws IOException {
        if (!this.isRunning()) {
            throw new IllegalStateException("Instance is already stopped.");
        }
        if (this.serviceDiscovery != null) {
            this.serviceDiscovery.stop();
        }
        this.running.set(false);
    }

    public synchronized void setAttemptsConfig(AttemptsConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Attempts configuration may not be null.");
        }
        this.attemptsConfig.numAttempts = config.numAttempts;
        this.attemptsConfig.timeBetweenAttempts = config.timeBetweenAttempts;
        this.attemptsConfig.timeBetweenAttempsUnit = config.timeBetweenAttempsUnit;
    }

    public synchronized AttemptsConfig getAttemptsConfig() {
        AttemptsConfig config = new AttemptsConfig();
        config.numAttempts = this.attemptsConfig.numAttempts;
        config.timeBetweenAttempts = this.attemptsConfig.timeBetweenAttempts;
        config.timeBetweenAttempsUnit = this.attemptsConfig.timeBetweenAttempsUnit;
        return config;
    }

    public static class AttemptsConfig {
        private int numAttempts = 1;
        private int timeBetweenAttempts = 1;
        private TimeUnit timeBetweenAttempsUnit = TimeUnit.SECONDS;

        public int getNumAttempts() {
            return this.numAttempts;
        }

        public void setNumAttempts(int numAttempts) {
            if (numAttempts <= 0) {
                throw new IllegalArgumentException("Number of attempts must be positive: " + numAttempts);
            }
            this.numAttempts = numAttempts;
        }

        public TimeUnit getTimeBetweenAttemptsUnit() {
            return this.timeBetweenAttempsUnit;
        }

        public void setTimeBetweenAttempsUnit(TimeUnit timeBetweenAttempsUnit) {
            if (this.timeBetweenAttempts <= 0) {
                throw new IllegalArgumentException("Time between attempts must be positive: " + this.numAttempts);
            }
            this.timeBetweenAttempsUnit = timeBetweenAttempsUnit;
        }

        public int getTimeBetweenAttempts() {
            return this.timeBetweenAttempts;
        }

        public void setTimeBetweenAttempts(int timeBetweenAttempts) {
            if (timeBetweenAttempts <= 0) {
                throw new IllegalArgumentException("Time between attempts must be positive: " + this.numAttempts);
            }
            this.timeBetweenAttempts = timeBetweenAttempts;
        }
    }
}

