/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.cluster.protocol.ProtocolContext;
import org.apache.nifi.cluster.protocol.ProtocolException;
import org.apache.nifi.cluster.protocol.ProtocolHandler;
import org.apache.nifi.cluster.protocol.ProtocolListener;
import org.apache.nifi.cluster.protocol.impl.MulticastProtocolListener;
import org.apache.nifi.cluster.protocol.message.ProtocolMessage;
import org.apache.nifi.cluster.protocol.message.ServiceBroadcastMessage;
import org.apache.nifi.io.socket.multicast.DiscoverableService;
import org.apache.nifi.io.socket.multicast.DiscoverableServiceImpl;
import org.apache.nifi.io.socket.multicast.MulticastConfiguration;
import org.apache.nifi.io.socket.multicast.MulticastServiceDiscovery;
import org.apache.nifi.reporting.BulletinRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterServiceDiscovery
implements MulticastServiceDiscovery,
ProtocolListener {
    private static final Logger logger = LoggerFactory.getLogger(ClusterServiceDiscovery.class);
    private final String serviceName;
    private final MulticastConfiguration multicastConfiguration;
    private final MulticastProtocolListener listener;
    private volatile BulletinRepository bulletinRepository;
    private DiscoverableService service;

    public ClusterServiceDiscovery(String serviceName, InetSocketAddress multicastAddress, MulticastConfiguration multicastConfiguration, ProtocolContext<ProtocolMessage> protocolContext) {
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            throw new IllegalArgumentException("Service name may not be null or empty.");
        }
        if (multicastAddress == null) {
            throw new IllegalArgumentException("Multicast address may not be null.");
        }
        if (!multicastAddress.getAddress().isMulticastAddress()) {
            throw new IllegalArgumentException("Multicast group must be a Class D address.");
        }
        if (protocolContext == null) {
            throw new IllegalArgumentException("Protocol Context may not be null.");
        }
        if (multicastConfiguration == null) {
            throw new IllegalArgumentException("Multicast configuration may not be null.");
        }
        this.serviceName = serviceName;
        this.multicastConfiguration = multicastConfiguration;
        this.listener = new MulticastProtocolListener(1, multicastAddress, multicastConfiguration, protocolContext);
        this.listener.addHandler(new ClusterManagerServiceBroadcastHandler());
    }

    @Override
    public void setBulletinRepository(BulletinRepository bulletinRepository) {
        this.bulletinRepository = bulletinRepository;
    }

    public synchronized DiscoverableService getService() {
        return this.service;
    }

    public InetSocketAddress getMulticastAddress() {
        return this.listener.getMulticastAddress();
    }

    @Override
    public Collection<ProtocolHandler> getHandlers() {
        return Collections.unmodifiableCollection(this.listener.getHandlers());
    }

    @Override
    public void addHandler(ProtocolHandler handler) {
        this.listener.addHandler(handler);
    }

    @Override
    public boolean removeHandler(ProtocolHandler handler) {
        return this.listener.removeHandler(handler);
    }

    @Override
    public boolean isRunning() {
        return this.listener.isRunning();
    }

    @Override
    public void start() throws IOException {
        if (this.isRunning()) {
            throw new IllegalStateException("Instance is already running.");
        }
        this.listener.start();
    }

    @Override
    public void stop() throws IOException {
        if (!this.isRunning()) {
            throw new IllegalStateException("Instance is already stopped.");
        }
        this.listener.stop();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public MulticastConfiguration getMulticastConfiguration() {
        return this.multicastConfiguration;
    }

    private String prettyPrint(InetSocketAddress address) {
        if (address == null) {
            return "0.0.0.0:0";
        }
        return address.getHostName() + ":" + address.getPort();
    }

    private class ClusterManagerServiceBroadcastHandler
    implements ProtocolHandler {
        private ClusterManagerServiceBroadcastHandler() {
        }

        @Override
        public boolean canHandle(ProtocolMessage msg) {
            return ProtocolMessage.MessageType.SERVICE_BROADCAST == msg.getType();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ProtocolMessage handle(ProtocolMessage msg) throws ProtocolException {
            ClusterServiceDiscovery clusterServiceDiscovery = ClusterServiceDiscovery.this;
            synchronized (clusterServiceDiscovery) {
                DiscoverableService oldService;
                if (!this.canHandle(msg)) {
                    throw new ProtocolException("Handler cannot handle message type: " + (Object)((Object)msg.getType()));
                }
                ServiceBroadcastMessage broadcastMsg = (ServiceBroadcastMessage)msg;
                if (ClusterServiceDiscovery.this.serviceName.equals(broadcastMsg.getServiceName()) && ((oldService = ClusterServiceDiscovery.this.service) == null || !broadcastMsg.getAddress().equalsIgnoreCase(oldService.getServiceAddress().getHostName()) || broadcastMsg.getPort() != oldService.getServiceAddress().getPort())) {
                    ClusterServiceDiscovery.this.service = (DiscoverableService)new DiscoverableServiceImpl(ClusterServiceDiscovery.this.serviceName, InetSocketAddress.createUnresolved(broadcastMsg.getAddress(), broadcastMsg.getPort()));
                    InetSocketAddress oldServiceAddress = oldService == null ? null : oldService.getServiceAddress();
                    logger.info(String.format("Updating cluster service address for '%s' from '%s' to '%s'", ClusterServiceDiscovery.this.serviceName, ClusterServiceDiscovery.this.prettyPrint(oldServiceAddress), ClusterServiceDiscovery.this.prettyPrint(ClusterServiceDiscovery.this.service.getServiceAddress())));
                }
                return null;
            }
        }
    }
}

