/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cluster.protocol.impl;

import java.io.IOException;
import java.util.Collection;
import org.apache.nifi.cluster.protocol.ClusterManagerProtocolSender;
import org.apache.nifi.cluster.protocol.ProtocolException;
import org.apache.nifi.cluster.protocol.ProtocolHandler;
import org.apache.nifi.cluster.protocol.ProtocolListener;
import org.apache.nifi.cluster.protocol.message.DisconnectMessage;
import org.apache.nifi.cluster.protocol.message.FlowRequestMessage;
import org.apache.nifi.cluster.protocol.message.FlowResponseMessage;
import org.apache.nifi.cluster.protocol.message.PrimaryRoleAssignmentMessage;
import org.apache.nifi.cluster.protocol.message.ReconnectionRequestMessage;
import org.apache.nifi.cluster.protocol.message.ReconnectionResponseMessage;
import org.apache.nifi.reporting.BulletinRepository;

public class ClusterManagerProtocolSenderListener
implements ClusterManagerProtocolSender,
ProtocolListener {
    private final ClusterManagerProtocolSender sender;
    private final ProtocolListener listener;

    public ClusterManagerProtocolSenderListener(ClusterManagerProtocolSender sender, ProtocolListener listener) {
        if (sender == null) {
            throw new IllegalArgumentException("ClusterManagerProtocolSender may not be null.");
        }
        if (listener == null) {
            throw new IllegalArgumentException("ProtocolListener may not be null.");
        }
        this.sender = sender;
        this.listener = listener;
    }

    @Override
    public void stop() throws IOException {
        if (!this.isRunning()) {
            throw new IllegalStateException("Instance is already stopped.");
        }
        this.listener.stop();
    }

    @Override
    public void start() throws IOException {
        if (this.isRunning()) {
            throw new IllegalStateException("Instance is already started.");
        }
        this.listener.start();
    }

    @Override
    public boolean isRunning() {
        return this.listener.isRunning();
    }

    @Override
    public boolean removeHandler(ProtocolHandler handler) {
        return this.listener.removeHandler(handler);
    }

    @Override
    public Collection<ProtocolHandler> getHandlers() {
        return this.listener.getHandlers();
    }

    @Override
    public void addHandler(ProtocolHandler handler) {
        this.listener.addHandler(handler);
    }

    @Override
    public void setBulletinRepository(BulletinRepository bulletinRepository) {
        this.listener.setBulletinRepository(bulletinRepository);
        this.sender.setBulletinRepository(bulletinRepository);
    }

    @Override
    public FlowResponseMessage requestFlow(FlowRequestMessage msg) throws ProtocolException {
        return this.sender.requestFlow(msg);
    }

    @Override
    public ReconnectionResponseMessage requestReconnection(ReconnectionRequestMessage msg) throws ProtocolException {
        return this.sender.requestReconnection(msg);
    }

    @Override
    public void disconnect(DisconnectMessage msg) throws ProtocolException {
        this.sender.disconnect(msg);
    }

    @Override
    public void assignPrimaryRole(PrimaryRoleAssignmentMessage msg) throws ProtocolException {
        this.sender.assignPrimaryRole(msg);
    }
}

