/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.event;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.nifi.distributed.cache.client.exception.SerializationException;

public class TableInfoCacheKey {
    private final String databaseName;
    private final String tableName;
    private final long tableId;
    private final String uuidPrefix;

    public TableInfoCacheKey(String uuidPrefix, String databaseName, String tableName, long tableId) {
        this.uuidPrefix = uuidPrefix;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.tableId = tableId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableInfoCacheKey that = (TableInfoCacheKey)o;
        return new EqualsBuilder().append(this.tableId, that.tableId).append((Object)this.databaseName, (Object)that.databaseName).append((Object)this.tableName, (Object)that.tableName).append((Object)this.uuidPrefix, (Object)that.uuidPrefix).isEquals();
    }

    public int hashCode() {
        int result = this.databaseName != null ? this.databaseName.hashCode() : 0;
        result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
        result = 31 * result + (int)(this.tableId ^ this.tableId >>> 32);
        result = 31 * result + (this.uuidPrefix != null ? this.uuidPrefix.hashCode() : 0);
        return result;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getTableId() {
        return this.tableId;
    }

    public String getUuidPrefix() {
        return this.uuidPrefix;
    }

    public static class Serializer
    implements org.apache.nifi.distributed.cache.client.Serializer<TableInfoCacheKey> {
        public void serialize(TableInfoCacheKey key, OutputStream output) throws SerializationException, IOException {
            StringBuilder sb = new StringBuilder(key.getUuidPrefix());
            sb.append("@!@");
            sb.append(key.getDatabaseName());
            sb.append("@!@");
            sb.append(key.getTableName());
            sb.append("@!@");
            sb.append(key.getTableId());
            output.write(sb.toString().getBytes());
        }
    }
}

