/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base.desktop;

import java.io.IOException;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.component.UIXHierarchy;
import org.apache.myfaces.trinidad.component.UIXNavigationLevel;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.BaseDesktopUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.HtmlLafRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.desktop.StyledItemUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.LinkUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.ModelRendererUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafRenderer;

@Deprecated
public class MenuListRenderer
extends HtmlLafRenderer {
    private static final String _LIST_STYLE_POSITION = ";list-style-position:outside";
    private static final String _LIST_STYLE_TYPE = "list-style-type:";
    private static final String _LOWER_ALPHA = "lower-alpha";
    private static final String _UPPER_ALPHA = "upper-alpha";

    @Override
    protected void prerender(UIXRenderingContext context, UINode node) throws IOException {
        super.prerender(context, node);
        StyledItemUtils.setSelected(context, false);
        ResponseWriter writer = context.getResponseWriter();
        String style = BaseDesktopUtils.getStringAttributeValue(context, node, LIST_STYLE_ATTR);
        if (style == null) {
            style = "disc";
        }
        if ("lowerAlpha".equals(style) || "upperAlpha".equals(style) || "decimal".equals(style)) {
            writer.startElement("ol", node.getUIComponent());
            super.renderAttributes(context, node);
            XhtmlLafRenderer.renderStyleClassAttribute(context, "OraStyledList");
            if ("lowerAlpha".equals(style)) {
                style = _LOWER_ALPHA;
            } else if ("upperAlpha".equals(style)) {
                style = _UPPER_ALPHA;
            }
            writer.writeAttribute("style", (Object)(_LIST_STYLE_TYPE + style), null);
        } else {
            writer.startElement("ul", node.getUIComponent());
            super.renderAttributes(context, node);
            XhtmlLafRenderer.renderStyleClassAttribute(context, "OraStyledList");
            StringBuffer inlineStyleBuffer = null;
            if ("none".equals(style) && MenuListRenderer.isIE(context)) {
                inlineStyleBuffer = new StringBuffer(_LIST_STYLE_TYPE.length() + style.length() + _LIST_STYLE_POSITION.length());
                inlineStyleBuffer.append(_LIST_STYLE_TYPE).append(style);
                inlineStyleBuffer.append(_LIST_STYLE_POSITION);
            } else if (style != null) {
                inlineStyleBuffer = new StringBuffer(_LIST_STYLE_TYPE.length() + style.length());
                inlineStyleBuffer.append(_LIST_STYLE_TYPE).append(style);
            }
            if (inlineStyleBuffer != null && inlineStyleBuffer.length() > 0) {
                writer.writeAttribute("style", (Object)inlineStyleBuffer.toString(), null);
            }
        }
    }

    protected UIXHierarchy getHierarchyBase(UIXRenderingContext context, UINode node) {
        return (UIXHierarchy)node.getUIComponent();
    }

    protected UINode getStamp(UIXRenderingContext context, UINode node) {
        return node.getNamedChild(context, "nodeStamp");
    }

    protected boolean setNewPath(UIXRenderingContext context, UINode node, UIXHierarchy component) {
        int startDepth = MenuListRenderer.getIntAttributeValue(context, node, LEVEL_ATTR, 0);
        return ModelRendererUtils.setNewPath(component, startDepth, ((UIXNavigationLevel)component).getFocusRowKey());
    }

    @Override
    protected void renderContent(UIXRenderingContext context, UINode node) throws IOException {
        UIXHierarchy component = this.getHierarchyBase(context, node);
        UINode stamp = this.getStamp(context, node);
        if (stamp != null) {
            Object oldPath = component.getRowKey();
            boolean isNewPath = this.setNewPath(context, node, component);
            if (isNewPath) {
                int size = component.getRowCount();
                int rowIndex = component.getRowIndex();
                for (int i = 0; i < size; ++i) {
                    component.setRowIndex(i);
                    boolean isRendered = MenuListRenderer.getBooleanAttributeValue(context, stamp, RENDERED_ATTR, true);
                    if (!isRendered) continue;
                    this.renderNode(context, stamp, i == rowIndex);
                }
                component.setRowKey(oldPath);
            }
        }
        super.renderContent(context, node);
    }

    @Override
    protected void postrender(UIXRenderingContext context, UINode node) throws IOException {
        ResponseWriter writer = context.getFacesContext().getResponseWriter();
        String style = BaseDesktopUtils.getStringAttributeValue(context, node, LIST_STYLE_ATTR);
        if ("lowerAlpha".equals(style) || "upperAlpha".equals(style) || "decimal".equals(style)) {
            writer.endElement("ol");
        } else {
            writer.endElement("ul");
        }
        super.postrender(context, node);
    }

    @Override
    protected void renderIndexedChild(UIXRenderingContext context, UINode node, int childIndex) throws IOException {
        UINode child = node.getIndexedChild(context, childIndex);
        boolean selected = MenuListRenderer.isSelected(context, child);
        this.renderNode(context, child, selected);
    }

    protected void renderNode(UIXRenderingContext context, UINode node, boolean selected) throws IOException {
        if (selected) {
            StyledItemUtils.setSelected(context, true);
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("li", null);
        writer.startElement("span", null);
        if (StyledItemUtils.isSelected(context, node)) {
            MenuListRenderer.renderStyleClassAttribute(context, "OraNav3Selected");
        } else {
            MenuListRenderer.renderStyleClassAttribute(context, "OraNav3");
        }
        boolean initialLinkSelectedStatus = LinkUtils.isSelected(context);
        node.render(context);
        LinkUtils.setSelected(context, initialLinkSelectedStatus);
        writer.endElement("span");
        writer.endElement("li");
        StyledItemUtils.setSelected(context, false);
    }
}

