/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.xml.parse;

import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.myfaces.trinidad.context.AccessibilityProfile;
import org.apache.myfaces.trinidad.context.LocaleContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Icon;
import org.apache.myfaces.trinidad.util.ArrayMap;
import org.apache.myfaces.trinidad.util.IntegerUtils;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.skin.icon.ContextImageIcon;
import org.apache.myfaces.trinidadinternal.skin.icon.NullIcon;
import org.apache.myfaces.trinidadinternal.skin.icon.TextIcon;
import org.apache.myfaces.trinidadinternal.skin.icon.URIImageIcon;
import org.apache.myfaces.trinidadinternal.style.PropertyParseException;
import org.apache.myfaces.trinidadinternal.style.StyleContext;
import org.apache.myfaces.trinidadinternal.style.UnmodifiableStyle;
import org.apache.myfaces.trinidadinternal.style.util.CSSUtils;
import org.apache.myfaces.trinidadinternal.style.util.ModeUtils;
import org.apache.myfaces.trinidadinternal.style.util.NameUtils;
import org.apache.myfaces.trinidadinternal.style.util.StyleUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.EmbeddedIncludePropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IconNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IncludePropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IncludeStyleNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.PropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleSheetNode;
import org.apache.myfaces.trinidadinternal.util.nls.LocaleUtils;

public class StyleSheetDocument {
    public static final long UNKNOWN_TIMESTAMP = -1L;
    private StyleSheetNode[] _styleSheets;
    private final String _documentVersion;
    private final long _documentTimestamp;
    private static final Set<String> _IE_SUPPRESSED_PROPERTIES = new HashSet<String>(Arrays.asList("border-radius", "box-shadow"));
    private static final Set<String> _DESTYLED_SUPPRESSED_PROPERTIES = new HashSet<String>(Arrays.asList("background-attachment", "background-color", "background-image", "background-position", "background-repeat", "background", "border-collapse", "border-color", "border-spacing", "border-style", "border-top", "border-right", "border-bottom", "border-left", "border-top-color", "border-right-color", "border-bottom-color", "border-left-color", "border-top-width", "border-right-width", "border-bottom-width", "border-left-width", "border-width", "border", "border-image", "border-radius", "caption-side", "color", "content", "cursor", "font-family", "font-size", "font-style", "font-variant", "font-weight", "font", "font-feature-settings", "font-kerning", "font-language-override", "font-size-adjust", "font-stretch", "font-variant-alternates", "font-variant-caps", "font-variant-east-asian", "font-variant-ligatures", "font-variant-numeric", "font-variant-position", "hanging-punctuation", "hyphens", "icon", "letter-spacing", "line-break", "list-style-image", "list-style-position", "list-style-type", "list-style", "margin-right", "margin-left", "margin-top", "margin-bottom", "margin", "marquee-direction", "marquee-loop", "marquee-speed", "marquee-style", "opacity", "outline-color", "outline-style", "outline-width", "outline", "outline-offset", "overflow-style", "overflow-wrap", "padding-top", "padding-right", "padding-bottom", "padding-left", "padding", "resize", "rotation", "rotation-point", "target-new", "target-position", "text-align", "text-align-last", "text-decoration", "text-indent", "text-justify", "text-transform", "text-overflow", "transition", "transition-delay", "transition-duration", "transition-property", "transition-timing-function", "vertical-align", "white-space", "word-break", "word-spacing", "word-wrap"));
    private static final String _FONT_SIZE_NAME = "font-size";
    private static final String _POINT_UNITS = "pt";
    private static final String _PIXEL_UNITS = "px";
    private static final StyleNode _ERROR_STYLE_NODE = new StyleNode("error", "error", null, null, null, null, null, null, null);
    private static final String _CIRCULAR_INCLUDE_ERROR = "Circular dependency detected in style ";
    private static final String _TR_PROPERTY_PREFIX = "-tr-";
    private static final Pattern _INTEGER_PATTERN = Pattern.compile("\\d+(px)?");
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(StyleSheetDocument.class);

    @Deprecated
    public StyleSheetDocument(StyleSheetNode[] styleSheets) {
        this(styleSheets, null, -1L);
    }

    @Deprecated
    public StyleSheetDocument(StyleSheetNode[] styleSheets, String documentVersion) {
        this(styleSheets, documentVersion, -1L);
    }

    public StyleSheetDocument(StyleSheetNode[] styleSheets, String documentVersion, long documentTimestamp) {
        if (styleSheets != null) {
            this._styleSheets = new StyleSheetNode[styleSheets.length];
            System.arraycopy(styleSheets, 0, this._styleSheets, 0, styleSheets.length);
        }
        this._documentVersion = documentVersion;
        this._documentTimestamp = documentTimestamp;
    }

    public String getDocumentId(StyleContext sContext) {
        int hashCode = 17;
        Iterator<StyleSheetNode> styleSheetNodes = this.getStyleSheets(sContext);
        while (styleSheetNodes.hasNext()) {
            hashCode = hashCode * 37 + styleSheetNodes.next().getStyleSheetId();
        }
        return Integer.toString(Math.abs(hashCode), 36);
    }

    public String getDocumentVersion() {
        return this._documentVersion;
    }

    public long getDocumentTimestamp() {
        return this._documentTimestamp;
    }

    public Iterator<StyleSheetNode> getStyleSheets() {
        return this.getStyleSheetsAsCollection().iterator();
    }

    public Collection<StyleSheetNode> getStyleSheetsAsCollection() {
        if (this._styleSheets == null) {
            return Arrays.asList(new StyleSheetNode[0]);
        }
        return Arrays.asList(this._styleSheets);
    }

    public Iterator<StyleSheetNode> getStyleSheets(StyleContext context) {
        return this.getStyleSheetsAsCollection(context).iterator();
    }

    public Collection<StyleSheetNode> getStyleSheetsAsCollection(StyleContext context) {
        return this._getStyleSheets(context).styleSheets();
    }

    public Iterator<IconNode> getIcons(StyleContext context) {
        StyleSheetList styleSheets = this._getStyleSheets(context);
        if (styleSheets.isEmpty()) {
            List emptyList = Collections.emptyList();
            return emptyList.iterator();
        }
        HashMap<String, StyleNode> resolvedStyles = new HashMap<String, StyleNode>();
        HashMap<String, StyleNode> resolvedNamedStyles = new HashMap<String, StyleNode>();
        HashSet<String> foundNames = new HashSet<String>();
        ArrayList<IconNode> iconNodes = new ArrayList<IconNode>();
        styleSheets.cacheIconIds();
        styleSheets.cacheStyleIds();
        for (StyleSheetNode styleSheet : styleSheets.styleSheets()) {
            Collection<IconNode> iconNodeList = styleSheet.getIcons();
            for (IconNode iconNodeFromStyleSheet : iconNodeList) {
                Icon icon;
                StyleNode resolvedNode;
                StyleNode sNode = iconNodeFromStyleSheet.getStyleNode();
                String clientRule = sNode == null ? null : sNode.getClientRule();
                String id = iconNodeFromStyleSheet.getIconName();
                boolean isFound = foundNames.contains(sNode.getId());
                if (isFound || (resolvedNode = this._resolveStyleNode(context, true, styleSheets, resolvedStyles, resolvedNamedStyles, null, null, id, false, sNode.getId(), clientRule)) == null || (icon = this._createIconFromNode(resolvedNode)) == null) continue;
                iconNodes.add(new IconNode(id, icon, resolvedNode));
                foundNames.add(resolvedNode.getId());
            }
        }
        return iconNodes.iterator();
    }

    private Icon _createIconFromNode(StyleNode resolvedNode) {
        Integer width = null;
        String widthValue = null;
        Integer height = null;
        String heightValue = null;
        String uri = null;
        String text = null;
        boolean isNullIcon = false;
        ArrayMap propertyMap = new ArrayMap();
        Collection<PropertyNode> properties = resolvedNode.getProperties();
        for (PropertyNode propertyNode : properties) {
            String propertyName = propertyNode.getName();
            String propertyValue = propertyNode.getValue();
            if (propertyName == null || propertyValue == null) continue;
            if (propertyName.equals("width")) {
                if (_INTEGER_PATTERN.matcher(propertyValue).matches()) {
                    widthValue = propertyValue;
                    width = StyleSheetDocument._convertPxDimensionStringToInteger(widthValue);
                    continue;
                }
                widthValue = null;
                propertyMap.put(propertyName, propertyValue);
                continue;
            }
            if (propertyName.equals("height")) {
                if (_INTEGER_PATTERN.matcher(propertyValue).matches()) {
                    heightValue = propertyValue;
                    height = StyleSheetDocument._convertPxDimensionStringToInteger(heightValue);
                    continue;
                }
                heightValue = null;
                propertyMap.put(propertyName, propertyValue);
                continue;
            }
            if (propertyName.equals("content")) {
                if (StyleSheetDocument._isURLValue(propertyValue)) {
                    uri = StyleSheetDocument._getURIString(propertyValue);
                    continue;
                }
                if (propertyValue.startsWith("inhibit")) {
                    isNullIcon = true;
                    continue;
                }
                text = StyleSheetDocument._trimQuotes(propertyValue);
                continue;
            }
            propertyMap.put(propertyName, propertyValue);
        }
        Icon icon = null;
        if (!isNullIcon) {
            if (text != null) {
                if (heightValue != null) {
                    propertyMap.put("height", heightValue);
                }
                if (widthValue != null) {
                    propertyMap.put("width", widthValue);
                }
                icon = new TextIcon(text, text, null, propertyMap.isEmpty() ? null : new UnmodifiableStyle((Map<String, String>)propertyMap));
            } else if (uri != null) {
                UnmodifiableStyle inlineStyle;
                boolean startsWithASlash = uri.startsWith("/");
                UnmodifiableStyle unmodifiableStyle = inlineStyle = propertyMap.isEmpty() ? null : new UnmodifiableStyle((Map<String, String>)propertyMap);
                icon = !startsWithASlash && !CSSUtils.isAbsoluteURI(uri) ? new ContextImageIcon(uri, uri, width, height, null, inlineStyle) : new URIImageIcon(uri, uri, width, height, null, inlineStyle);
            }
        } else {
            icon = NullIcon.sharedInstance();
        }
        return icon;
    }

    public Iterator<StyleNode> getStyles(StyleContext context) {
        StyleSheetList styleSheets = this._getStyleSheets(context);
        if (styleSheets.isEmpty()) {
            List emptyList = Collections.emptyList();
            return emptyList.iterator();
        }
        ArrayList<StyleNode> styles = new ArrayList<StyleNode>();
        HashMap<String, StyleNode> resolvedStyles = new HashMap<String, StyleNode>();
        HashMap<String, StyleNode> resolvedNamedStyles = new HashMap<String, StyleNode>();
        HashSet<String> foundSelectors = new HashSet<String>();
        HashSet<String> foundNames = new HashSet<String>();
        styleSheets.cacheStyleIds();
        for (StyleSheetNode styleSheet : styleSheets.styleSheets()) {
            Collection<StyleNode> styleNodeList = styleSheet.getStyles();
            for (StyleNode node : styleNodeList) {
                StyleNode resolvedNode;
                boolean isFound;
                String id;
                boolean isNamed;
                String cacheId = node.getId();
                if (node.getName() != null) {
                    isNamed = true;
                    id = node.getName();
                    isFound = foundNames.contains(cacheId);
                } else {
                    isNamed = false;
                    id = node.getSelector();
                    isFound = foundSelectors.contains(cacheId);
                }
                if (isFound || (resolvedNode = this._resolveStyleNode(context, false, styleSheets, resolvedStyles, resolvedNamedStyles, null, null, id, isNamed, cacheId, node.getClientRule())) == null) continue;
                cacheId = resolvedNode.getId();
                styles.add(resolvedNode);
                if (isNamed) {
                    foundNames.add(cacheId);
                    continue;
                }
                foundSelectors.add(cacheId);
            }
        }
        return styles.iterator();
    }

    public StyleNode getStyleBySelector(StyleContext context, String selector) {
        return this._getStyle(context, selector, false);
    }

    public StyleNode getStyleByName(StyleContext context, String name) {
        return this._getStyle(context, name, true);
    }

    private StyleSheetList _getStyleSheets(StyleContext context) {
        LocaleContext localeContext = context.getLocaleContext();
        Locale locale = localeContext.getTranslationLocale();
        int direction = LocaleUtils.getReadingDirection(localeContext);
        int mode = NameUtils.getMode(ModeUtils.getCurrentMode(context));
        TrinidadAgent agent = context.getAgent();
        AccessibilityProfile accProfile = context.getAccessibilityProfile();
        ArrayList<StyleSheetNode> v = new ArrayList<StyleSheetNode>();
        Iterator<StyleSheetNode> e = this.getStyleSheets();
        while (e.hasNext()) {
            StyleSheetNode styleSheet = e.next();
            if (styleSheet.compareVariants(locale, direction, agent, mode, accProfile) <= 0) continue;
            v.add(styleSheet);
        }
        int count = v.size();
        if (count == 0) {
            return new StyleSheetList(null);
        }
        StyleSheetNode[] styleSheets = v.toArray(new StyleSheetNode[count]);
        StyleSheetComparator comparator = new StyleSheetComparator(locale, direction, agent, mode, this._styleSheets, accProfile);
        Arrays.sort(styleSheets, comparator);
        return new StyleSheetList(styleSheets);
    }

    private StyleNode _getStyle(StyleContext context, String id, boolean isNamed) {
        StyleSheetList styleSheets = this._getStyleSheets(context);
        if (styleSheets.isEmpty()) {
            return null;
        }
        return this._resolveStyleNode(context, false, styleSheets, new HashMap<String, StyleNode>(19), new HashMap<String, StyleNode>(19), null, null, id, isNamed, null, null);
    }

    private StyleNode _resolveStyleNode(StyleContext context, boolean forIconNode, StyleSheetList styleSheets, Map<String, StyleNode> resolvedStyles, Map<String, StyleNode> resolvedNamedStyles, Deque<String> includesStack, Deque<String> namedIncludesStack, String id, boolean isNamed, String cacheId, String clientRule) {
        List<IconNode> iconNodeList;
        assert (styleSheets != null);
        assert (resolvedStyles != null);
        assert (resolvedNamedStyles != null);
        assert (id != null);
        StyleNode style = null;
        String selector = null;
        String name = null;
        if (cacheId == null) {
            cacheId = id;
        }
        if (isNamed) {
            style = resolvedNamedStyles.get(cacheId);
            name = id;
        } else {
            style = resolvedStyles.get(cacheId);
            selector = id;
        }
        if (style != null) {
            if (style == _ERROR_STYLE_NODE) {
                return null;
            }
            return style;
        }
        if (isNamed && StyleSheetDocument._stackContains(namedIncludesStack, cacheId) || !isNamed && StyleSheetDocument._stackContains(includesStack, cacheId)) {
            if (_LOG.isWarning()) {
                _LOG.warning(_CIRCULAR_INCLUDE_ERROR + id);
            }
            return null;
        }
        StyleEntry entry = new StyleEntry(selector, name, clientRule);
        if (isNamed) {
            if (namedIncludesStack == null) {
                namedIncludesStack = new ArrayDeque<String>();
            }
            namedIncludesStack.push(cacheId);
        } else {
            if (includesStack == null) {
                includesStack = new ArrayDeque<String>();
            }
            includesStack.push(cacheId);
        }
        List<StyleNode> nodeList = styleSheets.styleNodes(cacheId, isNamed);
        if (forIconNode && (iconNodeList = styleSheets.iconNodes(cacheId)) != null) {
            for (IconNode iconNode : iconNodeList) {
                StyleNode sNode = iconNode.getStyleNode();
                if (sNode == null) continue;
                if (nodeList == null) {
                    nodeList = new ArrayList<StyleNode>(iconNodeList.size());
                }
                nodeList.add(sNode);
            }
        }
        this._resolveStyleWork(context, id, forIconNode, styleSheets, resolvedStyles, resolvedNamedStyles, includesStack, namedIncludesStack, entry, nodeList);
        if (isNamed) {
            namedIncludesStack.pop();
        } else {
            includesStack.pop();
        }
        Set<String> blackList = null;
        StyleNode resolvedNode = entry.toStyleNode(blackList);
        if (resolvedNode != null) {
            String namedStyle = resolvedNode.getName();
            if (namedStyle != null) {
                resolvedNamedStyles.put(resolvedNode.getId(), resolvedNode);
            } else {
                String selectorStyle = resolvedNode.getSelector();
                if (selectorStyle != null) {
                    resolvedStyles.put(resolvedNode.getId(), resolvedNode);
                }
            }
        }
        return resolvedNode;
    }

    private void _resolveStyleWork(StyleContext context, String id, boolean forIconNode, StyleSheetList styleSheets, Map<String, StyleNode> resolvedStyles, Map<String, StyleNode> resolvedNamedStyles, Deque<String> includesStack, Deque<String> namedIncludesStack, StyleEntry entry, List<StyleNode> nodeList) {
        if (nodeList != null) {
            for (StyleNode node : nodeList) {
                if (node.__getResetProperties() || node.isInhibitingAll()) {
                    entry.resetProperties();
                }
                Collection<IncludeStyleNode> includedStyles = node.getIncludedStyles();
                for (IncludeStyleNode includeStyle : includedStyles) {
                    String includeID = null;
                    boolean includeIsNamed = false;
                    if (includeStyle.getName() != null) {
                        includeID = includeStyle.getName();
                        includeIsNamed = true;
                    } else {
                        includeID = includeStyle.getSelector();
                    }
                    StyleNode resolvedNode = this._resolveStyleNode(context, forIconNode, styleSheets, resolvedStyles, resolvedNamedStyles, includesStack, namedIncludesStack, includeID, includeIsNamed, null, null);
                    if (resolvedNode != null) {
                        this._addIncludedProperties(entry, resolvedNode);
                        continue;
                    }
                    if (!_LOG.isFinest() || forIconNode || !StyleUtils.isIcon(includeID) || !StyleUtils.isIcon(id)) continue;
                    _LOG.finest(id + " is being written to the CSS file " + "even though it is likely a Skin Icon Object, not a style.");
                }
                Collection<IncludePropertyNode> includedProperties = node.getIncludedProperties();
                for (IncludePropertyNode includeProperty : includedProperties) {
                    StyleNode resolvedNode = this._resolveIncludedProperties(context, forIconNode, styleSheets, resolvedStyles, resolvedNamedStyles, includesStack, namedIncludesStack, includeProperty);
                    if (resolvedNode == null) continue;
                    this._addIncludedProperty(entry, resolvedNode, includeProperty.getPropertyName(), includeProperty.getLocalPropertyName());
                }
                Collection<EmbeddedIncludePropertyNode> embeddedIncludeProperties = node.getEmbeddedIncludeProperties();
                for (EmbeddedIncludePropertyNode embeddedInclude : embeddedIncludeProperties) {
                    Map<String, IncludePropertyNode> ipNodes = embeddedInclude.getIncludedProperties();
                    HashMap<String, String> resolvedValues = new HashMap<String, String>();
                    for (Map.Entry<String, IncludePropertyNode> currEntry : ipNodes.entrySet()) {
                        List<PropertyNode> pNodes;
                        String placeHolder = currEntry.getKey();
                        IncludePropertyNode includeProperty = currEntry.getValue();
                        StyleNode resolvedNode = this._resolveIncludedProperties(context, forIconNode, styleSheets, resolvedStyles, resolvedNamedStyles, includesStack, namedIncludesStack, includeProperty);
                        if (resolvedNode == null || (pNodes = this._getIncludedPropertyNodes(resolvedNode, includeProperty.getPropertyName(), includeProperty.getLocalPropertyName())) == null || pNodes.isEmpty()) continue;
                        resolvedValues.put(placeHolder, pNodes.get(0).getValue());
                    }
                    if (resolvedValues.isEmpty() && !embeddedInclude.getPropertyValues().hasNext()) continue;
                    String compositeValue = this._createCompositeValue(embeddedInclude, resolvedValues);
                    String localName = embeddedInclude.getLocalPropertyName();
                    PropertyNode propertyNode = new PropertyNode(localName, compositeValue);
                    if (!localName.startsWith(_TR_PROPERTY_PREFIX)) {
                        entry.addProperty(propertyNode);
                        continue;
                    }
                    entry.addSkinProperty(propertyNode);
                }
                Collection<String> inhibitedProperties = node.getInhibitedProperties();
                for (String inhibitedPropertyName : inhibitedProperties) {
                    entry.removeProperty(inhibitedPropertyName);
                    entry.removeSkinProperty(inhibitedPropertyName);
                }
                Collection<PropertyNode> properties = node.getProperties();
                for (PropertyNode propertyNode : properties) {
                    entry.addProperty(propertyNode);
                }
                Collection<PropertyNode> skinProperties = node.getSkinProperties();
                for (PropertyNode skinPropNode : skinProperties) {
                    entry.addSkinProperty(skinPropNode);
                }
            }
        }
    }

    private String _createCompositeValue(EmbeddedIncludePropertyNode node, Map<String, String> values) {
        StringBuilder builder = new StringBuilder();
        Iterator<String> propertyValues = node.getPropertyValues();
        while (propertyValues.hasNext()) {
            String valueFrag = propertyValues.next();
            if (valueFrag.startsWith(_TR_PROPERTY_PREFIX)) {
                String resolvedValue = values.get(valueFrag);
                if (resolvedValue == null) continue;
                builder.append(resolvedValue);
                if (!propertyValues.hasNext()) continue;
                builder.append(" ");
                continue;
            }
            builder.append(valueFrag);
            if (!propertyValues.hasNext()) continue;
            builder.append(" ");
        }
        return builder.toString();
    }

    private StyleNode _resolveIncludedProperties(StyleContext context, boolean forIconNode, StyleSheetList styleSheets, Map<String, StyleNode> resolvedStyles, Map<String, StyleNode> resolvedNamedStyles, Deque<String> includesStack, Deque<String> namedIncludesStack, IncludePropertyNode includeProperty) {
        String includeID = null;
        boolean includeIsNamed = false;
        if (includeProperty.getName() != null) {
            includeID = includeProperty.getName();
            includeIsNamed = true;
        } else {
            includeID = includeProperty.getSelector();
        }
        StyleNode resolvedNode = this._resolveStyleNode(context, forIconNode, styleSheets, resolvedStyles, resolvedNamedStyles, includesStack, namedIncludesStack, includeID, includeIsNamed, null, null);
        return resolvedNode;
    }

    private void _addIncludedProperties(StyleEntry entry, StyleNode node) {
        if (node == null) {
            return;
        }
        Collection<PropertyNode> properties = node.getProperties();
        for (PropertyNode propertyNode : properties) {
            if (propertyNode == null) continue;
            entry.addProperty(propertyNode);
        }
        Collection<PropertyNode> skinProperties = node.getSkinProperties();
        for (PropertyNode skinPropertyNode : skinProperties) {
            entry.addSkinProperty(skinPropertyNode);
        }
    }

    private void _addIncludedProperty(StyleEntry entry, StyleNode node, String propertyName, String localPropertyName) {
        block6: {
            if (node == null) {
                return;
            }
            if (localPropertyName == null) break block6;
            if (localPropertyName.startsWith(_TR_PROPERTY_PREFIX)) {
                Collection<PropertyNode> properties = node.getProperties();
                List<PropertyNode> includedProperties = this._getIncludedProperties(propertyName, localPropertyName, properties);
                for (PropertyNode propertyToAdd : includedProperties) {
                    entry.addSkinProperty(propertyToAdd);
                }
                Collection<PropertyNode> skinProperties = node.getSkinProperties();
                List<PropertyNode> includedSkinProperties = this._getIncludedProperties(propertyName, localPropertyName, skinProperties);
                for (PropertyNode propertyToAdd : includedSkinProperties) {
                    entry.addSkinProperty(propertyToAdd);
                }
            } else {
                Collection<PropertyNode> properties = node.getProperties();
                List<PropertyNode> includedProperties = this._getIncludedProperties(propertyName, localPropertyName, properties);
                for (PropertyNode propertyToAdd : includedProperties) {
                    entry.addProperty(propertyToAdd);
                }
            }
        }
    }

    private List<PropertyNode> _getIncludedPropertyNodes(StyleNode node, String propertyName, String localPropertyName) {
        if (node == null || localPropertyName == null) {
            return Collections.emptyList();
        }
        if (localPropertyName.startsWith(_TR_PROPERTY_PREFIX)) {
            Collection<PropertyNode> properties = node.getProperties();
            List<PropertyNode> includedProperties = this._getIncludedProperties(propertyName, localPropertyName, properties);
            Collection<PropertyNode> skinProperties = node.getSkinProperties();
            List<PropertyNode> pNodes = this._getIncludedProperties(propertyName, localPropertyName, skinProperties);
            includedProperties.addAll(pNodes);
            return includedProperties;
        }
        Collection<PropertyNode> properties = node.getProperties();
        List<PropertyNode> includedProperties = this._getIncludedProperties(propertyName, localPropertyName, properties);
        return includedProperties;
    }

    private List<PropertyNode> _getIncludedProperties(String propertyName, String localPropertyName, Iterable<PropertyNode> properties) {
        ArrayList<PropertyNode> propertyNodesToAdd = new ArrayList<PropertyNode>();
        for (PropertyNode property : properties) {
            if (!propertyName.equals(property.getName())) continue;
            if (!propertyName.equals(localPropertyName)) {
                property = new PropertyNode(localPropertyName, property.getValue());
            }
            propertyNodesToAdd.add(property);
        }
        return propertyNodesToAdd;
    }

    static PropertyNode _getRealFontSize(PropertyNode property, int relativeFontSize) {
        if (relativeFontSize == 0) {
            return property;
        }
        String value = property.getValue();
        String units = _POINT_UNITS;
        if (value.endsWith(_POINT_UNITS)) {
            value = value.substring(0, value.length() - _POINT_UNITS.length());
            units = _POINT_UNITS;
        } else if (value.endsWith(_PIXEL_UNITS)) {
            value = value.substring(0, value.length() - _PIXEL_UNITS.length());
            units = _PIXEL_UNITS;
        }
        int size = 0;
        try {
            size = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            _LOG.fine("Could not parse font size: " + value + ". Returning the property as is.");
            return property;
        }
        String newValue = IntegerUtils.getString((int)(size += relativeFontSize)) + units;
        return new PropertyNode(_FONT_SIZE_NAME, newValue);
    }

    private static Integer _convertPxDimensionStringToInteger(String propertyValue) {
        int pxPosition = propertyValue.indexOf(_PIXEL_UNITS);
        if (pxPosition > -1) {
            propertyValue = propertyValue.substring(0, pxPosition);
        }
        return Integer.valueOf(propertyValue);
    }

    private static boolean _isURLValue(String propertyValue) {
        return propertyValue.startsWith("url(");
    }

    private static String _trimQuotes(String in) {
        if (in == null) {
            return in;
        }
        boolean startsWithDoubleQuote = in.startsWith("\"");
        boolean startsWithSingleQuote = in.startsWith("'");
        boolean endsWithDoubleQuote = in.endsWith("\"");
        boolean endsWithSingleQuote = in.endsWith("'");
        if ((startsWithDoubleQuote && endsWithSingleQuote || startsWithSingleQuote && endsWithDoubleQuote) && _LOG.isWarning()) {
            _LOG.warning("ERR_PARSING", (Object)in);
        }
        if (startsWithDoubleQuote && endsWithDoubleQuote) {
            return in.substring(1, in.length() - 1);
        }
        if (startsWithSingleQuote && endsWithSingleQuote) {
            return in.substring(1, in.length() - 1);
        }
        return in;
    }

    private static String _getURIString(String propertyValue) {
        assert (StyleSheetDocument._isURLValue(propertyValue));
        int uriEnd = propertyValue.indexOf(41);
        String uri = propertyValue.substring(4, uriEnd);
        return StyleSheetDocument._trimQuotes(uri);
    }

    private static boolean _stackContains(Deque<?> stack, Object value) {
        if (stack == null) {
            return false;
        }
        return stack.contains(value);
    }

    private static class StyleEntry {
        public final String selector;
        public final String name;
        public final String clientRule;
        private static final PropertyNode[] _EMPTY_PROPERTY_NODE_ARRAY = new PropertyNode[0];
        private ArrayList<PropertyNode> _properties;
        private ArrayList<PropertyNode> _skinProperties;
        private int _propertyCount;
        private int _skinPropertyCount;
        private int _relativeFontSize;

        public StyleEntry(String selector, String name, String clientRule) {
            this.selector = selector;
            this.name = name;
            this.clientRule = clientRule;
        }

        public void addSkinProperty(PropertyNode property) {
            if (this._skinProperties == null) {
                this._skinProperties = new ArrayList(2);
            }
            String name = property.getName();
            this.removeSkinProperty(name);
            this._skinProperties.add(property);
        }

        public void addProperty(PropertyNode property) {
            if (this._properties == null) {
                this._properties = new ArrayList(5);
            }
            if (this._isRelativeFontSize(property)) {
                this._addRelativeFontSize(property);
            } else if (this._isRelativeColor(property)) {
                this._addRelativeColor(property);
            } else {
                String name = property.getName();
                this.removeProperty(name);
                this._properties.add(property);
                ++this._propertyCount;
                if (name.equals(StyleSheetDocument._FONT_SIZE_NAME)) {
                    this._relativeFontSize = 0;
                }
            }
        }

        public void removeProperty(String name) {
            if (this._removeProperty(this._properties, name)) {
                --this._propertyCount;
            }
        }

        public void removeSkinProperty(String name) {
            if (this._removeSkinProperty(this._skinProperties, name)) {
                --this._skinPropertyCount;
            }
        }

        public void resetProperties() {
            this._skinProperties = null;
            this._skinPropertyCount = 0;
            this._properties = null;
            this._propertyCount = 0;
            this._relativeFontSize = 0;
        }

        private static PropertyNode[] _filterAndTrimPropertyNodes(List<PropertyNode> unfilteredProperties, Set<String> blackList, int relativeFontSize) {
            int propertyCount;
            int n = propertyCount = unfilteredProperties != null ? unfilteredProperties.size() : 0;
            if (propertyCount == 0) {
                return _EMPTY_PROPERTY_NODE_ARRAY;
            }
            PropertyNode[] filteredProperties = StyleEntry._filteredCopyInto(unfilteredProperties, blackList, new PropertyNode[propertyCount]);
            if (relativeFontSize != 0) {
                for (int i = 0; i < filteredProperties.length; ++i) {
                    PropertyNode property = filteredProperties[i];
                    if (!StyleSheetDocument._FONT_SIZE_NAME.equals(property.getName())) continue;
                    filteredProperties[i] = StyleSheetDocument._getRealFontSize(property, relativeFontSize);
                    break;
                }
            }
            return filteredProperties;
        }

        public StyleNode toStyleNode(Set<String> blackList) {
            PropertyNode[] skinProperties;
            PropertyNode[] properties = StyleEntry._filterAndTrimPropertyNodes(this._properties, blackList, this._relativeFontSize);
            if (properties.length + (skinProperties = StyleEntry._filterAndTrimPropertyNodes(this._skinProperties, null, 0)).length == 0) {
                return null;
            }
            return new StyleNode(this.name, this.selector, this.clientRule, properties, skinProperties, null, null, null, null);
        }

        private boolean _removeProperty(ArrayList<PropertyNode> properties, String name) {
            if (properties == null) {
                return false;
            }
            for (int i = 0; i < properties.size(); ++i) {
                PropertyNode property = properties.get(i);
                if (property == null || !property.getName().equals(name)) continue;
                properties.set(i, null);
                return true;
            }
            return false;
        }

        private boolean _removeSkinProperty(ArrayList<PropertyNode> properties, String name) {
            if (properties == null) {
                return false;
            }
            for (int i = 0; i < properties.size(); ++i) {
                PropertyNode property = properties.get(i);
                if (property == null || !property.getName().equals(name)) continue;
                properties.set(i, null);
                return true;
            }
            return false;
        }

        private static PropertyNode[] _filteredCopyInto(List<? extends PropertyNode> source, Set<String> blackList, PropertyNode[] target) {
            int copyIndex = 0;
            int sourceSize = source.size();
            for (int i = 0; i < sourceSize; ++i) {
                PropertyNode property = source.get(i);
                if (property == null || blackList != null && blackList.contains(property.getName())) continue;
                target[copyIndex] = property;
                ++copyIndex;
            }
            if (sourceSize != copyIndex) {
                if (copyIndex != 0) {
                    return Arrays.copyOf(target, copyIndex);
                }
                return _EMPTY_PROPERTY_NODE_ARRAY;
            }
            return target;
        }

        private boolean _isRelativeFontSize(PropertyNode property) {
            if (!StyleSheetDocument._FONT_SIZE_NAME.equals(property.getName())) {
                return false;
            }
            String value = property.getValue();
            if (value != null && value.length() > 0) {
                char c = value.charAt(0);
                return c == '+' || c == '-';
            }
            return false;
        }

        private boolean _isRelativeColor(PropertyNode property) {
            String value = property.getValue();
            if (value == null) {
                return false;
            }
            int length = value.length();
            if (length != 8 && length != 5) {
                return false;
            }
            char c0 = value.charAt(0);
            return (c0 == '+' || c0 == '-') && value.charAt(1) == '#';
        }

        private void _addRelativeFontSize(PropertyNode property) {
            boolean increment;
            assert (this._isRelativeFontSize(property));
            String value = property.getValue();
            boolean bl = increment = value.charAt(0) == '+';
            value = value.endsWith(StyleSheetDocument._POINT_UNITS) ? value.substring(1, value.length() - StyleSheetDocument._POINT_UNITS.length()) : (value.endsWith(StyleSheetDocument._PIXEL_UNITS) ? value.substring(1, value.length() - StyleSheetDocument._PIXEL_UNITS.length()) : value.substring(1));
            int size = 0;
            try {
                size = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return;
            }
            this._relativeFontSize = increment ? (this._relativeFontSize += size) : (this._relativeFontSize -= size);
        }

        private void _addRelativeColor(PropertyNode property) {
            assert (this._isRelativeColor(property));
            String relativeValue = property.getValue();
            boolean increment = relativeValue.charAt(0) == '+';
            Color relativeColor = null;
            try {
                relativeColor = CSSUtils.parseColor(relativeValue.substring(1));
            }
            catch (PropertyParseException propertyParseException) {
                // empty catch block
            }
            if (relativeColor == null) {
                return;
            }
            String absoluteValue = this._getPropertyValue(property.getName());
            if (absoluteValue == null) {
                return;
            }
            Color absoluteColor = null;
            try {
                absoluteColor = CSSUtils.parseColor(absoluteValue);
            }
            catch (PropertyParseException propertyParseException) {
                // empty catch block
            }
            if (absoluteColor == null) {
                return;
            }
            int red = absoluteColor.getRed();
            int green = absoluteColor.getGreen();
            int blue = absoluteColor.getBlue();
            if (increment) {
                red = Math.min(red + relativeColor.getRed(), 255);
                green = Math.min(green + relativeColor.getGreen(), 255);
                blue = Math.min(blue + relativeColor.getBlue(), 255);
            } else {
                red = Math.max(red - relativeColor.getRed(), 0);
                green = Math.max(green - relativeColor.getGreen(), 0);
                blue = Math.max(blue - relativeColor.getBlue(), 0);
            }
            Color resolvedColor = new Color(red, green, blue);
            String resolvedValue = CSSUtils.getColorValue(resolvedColor);
            this.addProperty(new PropertyNode(property.getName(), resolvedValue));
        }

        private String _getPropertyValue(String name) {
            if (this._properties != null) {
                for (PropertyNode property : this._properties) {
                    if (property == null || !name.equals(property.getName())) continue;
                    return property.getValue();
                }
            }
            return null;
        }
    }

    private static class StyleSheetComparator
    implements Comparator<StyleSheetNode> {
        private Locale _locale;
        private int _direction;
        private TrinidadAgent _agent;
        private int _mode;
        private StyleSheetNode[] _styleSheets;
        private AccessibilityProfile _accProfile;

        public StyleSheetComparator(Locale locale, int direction, TrinidadAgent agent, int mode, StyleSheetNode[] styleSheets, AccessibilityProfile accessibilityProfile) {
            this._direction = direction;
            this._locale = locale;
            this._agent = agent;
            this._styleSheets = styleSheets;
            this._mode = mode;
            this._accProfile = accessibilityProfile;
        }

        @Override
        public int compare(StyleSheetNode item1, StyleSheetNode item2) {
            int match2;
            if (item1 == item2) {
                return 0;
            }
            int match1 = item1.compareVariants(this._locale, this._direction, this._agent, this._mode, this._accProfile);
            if (match1 == (match2 = item2.compareVariants(this._locale, this._direction, this._agent, this._mode, this._accProfile))) {
                return this._compareOrder(item1, item2);
            }
            if (match1 < match2) {
                return -1;
            }
            return 1;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StyleSheetComparator)) {
                return false;
            }
            StyleSheetComparator other = (StyleSheetComparator)o;
            return this._direction == other._direction && this._mode == other._mode && this._locale.equals(other._locale) && this._accProfile.equals((Object)other._accProfile) && this._agent.equals(other._agent) && this._styleSheets.equals(other._styleSheets);
        }

        private int _compareOrder(Object item1, Object item2) {
            assert (item1 != item2);
            for (int i = 0; i < this._styleSheets.length; ++i) {
                StyleSheetNode styleSheet = this._styleSheets[i];
                if (styleSheet == item1) {
                    return -1;
                }
                if (styleSheet != item2) continue;
                return 1;
            }
            assert (false);
            return 0;
        }
    }

    private static class StyleSheetList {
        private Map<String, List<StyleNode>> _nameNodes;
        private Map<String, List<StyleNode>> _selectorNodes;
        private Map<String, List<IconNode>> _iconNodes;
        private final StyleSheetNode[] _styleSheets;

        public StyleSheetList(StyleSheetNode[] styleSheets) {
            this._styleSheets = styleSheets;
        }

        public boolean isEmpty() {
            return this._styleSheets == null || this._styleSheets.length == 0;
        }

        public void cacheStyleIds() {
            this._nameNodes = new HashMap<String, List<StyleNode>>(512);
            this._selectorNodes = new HashMap<String, List<StyleNode>>(4096);
            for (int i = 0; i < this._styleSheets.length; ++i) {
                StyleSheetNode styleSheet = this._styleSheets[i];
                Collection<StyleNode> styleNodeList = styleSheet.getStyles();
                for (StyleNode node : styleNodeList) {
                    if (node.getName() != null) {
                        StyleSheetList._addToStyleMap(this._nameNodes, node, node.getId());
                        continue;
                    }
                    StyleSheetList._addToStyleMap(this._selectorNodes, node, node.getId());
                }
            }
        }

        public void cacheIconIds() {
            this._iconNodes = new HashMap<String, List<IconNode>>(1024);
            for (int i = 0; i < this._styleSheets.length; ++i) {
                StyleSheetNode styleSheet = this._styleSheets[i];
                Collection<IconNode> iconNodeList = styleSheet.getIcons();
                for (IconNode node : iconNodeList) {
                    if (node.getIconName() == null) continue;
                    StyleSheetList._addToIconMap(this._iconNodes, node, node.getIconName());
                }
            }
        }

        public List<StyleNode> styleNodes(String cacheId, boolean isNamed) {
            Map<String, List<StyleNode>> m;
            if (this._styleSheets == null) {
                return Collections.emptyList();
            }
            Map<String, List<StyleNode>> map = m = isNamed ? this._nameNodes : this._selectorNodes;
            if (m != null) {
                return m.get(cacheId);
            }
            ArrayList<StyleNode> l = new ArrayList<StyleNode>();
            for (int i = 0; i < this._styleSheets.length; ++i) {
                StyleSheetNode styleSheet = this._styleSheets[i];
                Collection<StyleNode> styleNodeList = styleSheet.getStyles();
                for (StyleNode node : styleNodeList) {
                    if (!cacheId.equals(node.getId())) continue;
                    l.add(node);
                }
            }
            return l;
        }

        public List<IconNode> iconNodes(String cacheId) {
            if (this._styleSheets == null) {
                return Collections.emptyList();
            }
            Map<String, List<IconNode>> m = this._iconNodes;
            if (m != null) {
                return m.get(cacheId);
            }
            ArrayList<IconNode> l = new ArrayList<IconNode>();
            for (int i = 0; i < this._styleSheets.length; ++i) {
                StyleSheetNode styleSheet = this._styleSheets[i];
                Collection<IconNode> iconNodeList = styleSheet.getIcons();
                for (IconNode node : iconNodeList) {
                    if (!cacheId.equals(node.getStyleNode().getId())) continue;
                    l.add(node);
                }
            }
            return l;
        }

        public List<StyleSheetNode> styleSheets() {
            if (this._styleSheets == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(Arrays.asList(this._styleSheets));
        }

        private static void _addToStyleMap(Map<String, List<StyleNode>> m, StyleNode node, String id) {
            List<StyleNode> l = m.get(id);
            if (l == null) {
                l = new ArrayList<StyleNode>(6);
                m.put(id, l);
            }
            l.add(node);
        }

        private static void _addToIconMap(Map<String, List<IconNode>> m, IconNode node, String id) {
            List<IconNode> l = m.get(id);
            if (l == null) {
                l = new ArrayList<IconNode>(6);
                m.put(id, l);
            }
            l.add(node);
        }
    }
}

