/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.skin.provider;

import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.skin.Skin;
import org.apache.myfaces.trinidad.skin.SkinFactory;
import org.apache.myfaces.trinidad.skin.SkinMetadata;
import org.apache.myfaces.trinidadinternal.config.GlobalConfiguratorImpl;
import org.apache.myfaces.trinidadinternal.skin.provider.BaseSkinProvider;

public class ExternalSkinProvider
extends BaseSkinProvider {
    public static final String EXTERNAL_SKIN_PROVIDER_KEY = "org.apache.myfaces.trinidad.skin.EXTERNAL_SKIN_PROVIDER_INSTANCE";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ExternalSkinProvider.class);

    @Override
    public Skin getSkin(ExternalContext context, SkinMetadata skinMetadata) {
        return super.getSkin(context, skinMetadata);
    }

    @Override
    protected Skin loadAvailableSkin(ExternalContext context, SkinMetadata skinMetadata) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reload() {
        ExternalSkinProvider externalSkinProvider = this;
        synchronized (externalSkinProvider) {
            FacesContext fc = FacesContext.getCurrentInstance();
            if (fc != null) {
                SkinFactory factory = SkinFactory.getFactory();
                _LOG.fine("Reloading skins begin");
                Map<SkinMetadata, Skin> oldSkins = this.getSkins();
                this.initSkins();
                try {
                    GlobalConfiguratorImpl.getInstance().reloadSkins(fc.getExternalContext(), factory);
                }
                catch (Exception e) {
                    _LOG.severe("SKIN_RELOAD_FAILURE", (Throwable)e);
                    this.setSkins(oldSkins);
                }
                finally {
                    _LOG.fine("Reloading skins complete");
                }
            }
        }
    }

    public static ExternalSkinProvider getCurrentInstance(ExternalContext ec) {
        if (ec == null) {
            throw new NullPointerException("ExternalContext is passed as null");
        }
        ExternalSkinProvider esp = (ExternalSkinProvider)((Object)ec.getApplicationMap().get(EXTERNAL_SKIN_PROVIDER_KEY));
        return esp;
    }
}

