/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.input.CoreSelectBooleanRadio;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.SimpleSelectBooleanRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class SimpleSelectBooleanRadioRenderer
extends SimpleSelectBooleanRenderer {
    private PropertyKey _groupKey;

    public SimpleSelectBooleanRadioRenderer() {
        this(CoreSelectBooleanRadio.TYPE);
    }

    public SimpleSelectBooleanRadioRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._groupKey = type.findKey("group");
    }

    @Override
    public Object getSubmittedValue(FacesContext context, UIComponent component, String clientId) {
        Object newValue;
        this.detectAutoSubmit(context, component, clientId);
        String group = this.getGroup(this.getFacesBean(component));
        if (group != null && clientId.equals(newValue = context.getExternalContext().getRequestParameterMap().get(group))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    protected Object getValueAttr(RenderingContext rc) {
        return rc.getCurrentClientId();
    }

    @Override
    protected Object getType() {
        return "radio";
    }

    @Override
    protected String getIconAltTextName(boolean selected) {
        return selected ? "af_selectBooleanRadio.READONLY_CHECKED_TIP" : "af_selectBooleanRadio.READONLY_NOT_CHECKED_TIP";
    }

    @Override
    protected String getIconName(boolean selected, boolean disabled) {
        String iconName = disabled ? (selected ? "af|selectBooleanRadio::disabled-selected-icon" : "af|selectBooleanRadio::disabled-unselected-icon") : (selected ? "af|selectBooleanRadio::read-only-selected-icon" : "af|selectBooleanRadio::read-only-unselected-icon");
        return iconName;
    }

    @Override
    protected void renderNameAttribute(FacesContext context, RenderingContext arc, FacesBean bean) throws IOException {
        String group = this.getGroup(bean);
        if (group != null) {
            ResponseWriter writer = context.getResponseWriter();
            writer.writeAttribute("name", (Object)group, null);
        }
    }

    @Override
    protected boolean shouldRenderName(FacesContext context, UIComponent component) {
        return false;
    }

    @Override
    protected boolean isRadio() {
        return true;
    }

    @Override
    protected String getCompositeId(String clientId) {
        return clientId + "__xc_" + "r";
    }

    @Override
    protected void renderSpanEventHandlers(FacesContext context, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        if (!SimpleSelectBooleanRadioRenderer.isPDA((RenderingContext)RenderingContext.getCurrentInstance()) && this.isAutoSubmit(component, bean)) {
            rw.writeAttribute("onclick", (Object)this.getAutoSubmitScript(component, bean), null);
        }
        rw.writeAttribute("ondblclick", (Object)this.getOndblclick(component, bean), "ondblclick");
        rw.writeAttribute("onkeydown", (Object)this.getOnkeydown(component, bean), "onkeydown");
        rw.writeAttribute("onkeyup", (Object)this.getOnkeyup(component, bean), "onkeyup");
        rw.writeAttribute("onkeypress", (Object)this.getOnkeypress(component, bean), "onkeypress");
        rw.writeAttribute("onmousedown", (Object)this.getOnmousedown(component, bean), "onmousedown");
        rw.writeAttribute("onmousemove", (Object)this.getOnmousemove(component, bean), "onmousemove");
        rw.writeAttribute("onmouseout", (Object)this.getOnmouseout(component, bean), "onmouseout");
        rw.writeAttribute("onmouseover", (Object)this.getOnmouseover(component, bean), "onmouseover");
        rw.writeAttribute("onmouseup", (Object)this.getOnmouseup(component, bean), "onmouseup");
    }

    @Override
    protected void renderInputEventHandlers(FacesContext context, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String onClick = this.getOnclick(component, bean);
        if (SimpleSelectBooleanRadioRenderer.isPDA((RenderingContext)RenderingContext.getCurrentInstance()) && this.isAutoSubmit(component, bean)) {
            String auto = this.getAutoSubmitScript(component, bean);
            onClick = onClick == null ? auto : XhtmlUtils.getChainedJS(onClick, auto, true);
        }
        writer.writeAttribute("onclick", (Object)onClick, "onclick");
        writer.writeAttribute("onblur", (Object)this.getOnblur(component, bean), "onblur");
        writer.writeAttribute("onfocus", (Object)this.getOnfocus(component, bean), "onfocus");
        writer.writeAttribute("onchange", (Object)this.getOnchange(component, bean), "onchange");
    }

    protected String getGroup(FacesBean bean) {
        return SimpleSelectBooleanRadioRenderer.toString((Object)bean.getProperty(this._groupKey));
    }

    @Override
    protected String getContentStyleClass(UIComponent component, FacesBean bean) {
        return "af|selectBooleanRadio::content";
    }

    @Override
    protected String getRootStyleClass(UIComponent component, FacesBean bean) {
        return "af|selectBooleanRadio";
    }
}

