/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.UIXShowDetail;
import org.apache.myfaces.trinidad.component.core.layout.CorePanelAccordion;
import org.apache.myfaces.trinidad.component.core.layout.CoreShowDetailItem;
import org.apache.myfaces.trinidad.context.FormData;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.DisclosureEvent;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.ShowDetailRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class PanelAccordionRenderer
extends XhtmlRenderer {
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(PanelAccordionRenderer.class);
    private PropertyKey _discloseNoneKey;
    private PropertyKey _discloseManyKey;
    private static final String _DISCLOSED_TIP_KEY = "af_panelAccordion.DISCLOSED_TIP";
    private static final String _UNDISCLOSED_TIP_KEY = "af_panelAccordion.UNDISCLOSED_TIP";

    public PanelAccordionRenderer() {
        super(CorePanelAccordion.TYPE);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._discloseNoneKey = type.findKey("discloseNone");
        this._discloseManyKey = type.findKey("discloseMany");
    }

    protected void decode(FacesContext facesContext, UIComponent component, FacesBean facesBean, String clientId) {
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        Object event = parameters.get("event");
        if ("hide".equals(event) || "show".equals(event)) {
            String id;
            Object source = parameters.get("source");
            String string = id = clientId == null ? component.getClientId(facesContext) : clientId;
            if (id.equals(source)) {
                boolean isDisclosed = "show".equals(event);
                String itemId = (String)parameters.get("targetItem");
                if (itemId != null) {
                    List children = component.getChildren();
                    for (UIComponent child : children) {
                        if (!(child instanceof UIXShowDetail) || !child.isRendered() || this._isItemDisabled(child) || !itemId.equals(child.getClientId(facesContext))) continue;
                        new DisclosureEvent(child, isDisclosed).queue();
                        RequestContext rc = RequestContext.getCurrentInstance();
                        Object cap = rc.getAgent().getCapabilities().get(TrinidadAgent.CAP_PARTIAL_RENDERING);
                        if (cap == null || !Boolean.TRUE.equals(cap)) break;
                        RequestContext.getCurrentInstance().addPartialTarget(component);
                        PartialPageUtils.forcePartialRendering(facesContext);
                        break;
                    }
                }
            }
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected boolean shouldRenderId(FacesContext context, UIComponent component) {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        UIXShowDetail detailItem;
        FormData fData = rc.getFormData();
        String formName = "";
        if (fData != null) {
            formName = fData.getName();
            if (formName == null) {
                _LOG.warning("PANELACCORDION_MUST_INSIDE_FORM");
                return;
            }
            boolean pprEnabled = PartialPageUtils.supportsPartialRendering(rc);
            if (!pprEnabled) {
                fData.addNeededValue("targetItem");
            }
        }
        List children = component.getChildren();
        int numChildren = children.size();
        UIXShowDetail disclosedChild = null;
        UIXShowDetail renderableChild = null;
        for (int indxChild = 0; indxChild < numChildren; ++indxChild) {
            UIXShowDetail detailChild;
            UIComponent child = (UIComponent)children.get(indxChild);
            if (!(child instanceof UIXShowDetail) || !(detailChild = (UIXShowDetail)children.get(indxChild)).isRendered() || this._isItemDisabled((UIComponent)detailChild)) continue;
            if (renderableChild == null) {
                renderableChild = detailChild;
            }
            if (!detailChild.isDisclosed()) continue;
            disclosedChild = detailChild;
            break;
        }
        if (disclosedChild == null && !this.getDiscloseNone(component, bean) && renderableChild != null && !renderableChild.isDisclosedTransient()) {
            renderableChild.setDisclosed(true);
        }
        ResponseWriter out = context.getResponseWriter();
        String compId = component.getClientId(context);
        out.startElement("div", component);
        this.renderId(context, component);
        this.renderAllAttributes(context, rc, component, bean);
        boolean discloseMany = this.getDiscloseMany(component, bean);
        boolean discloseNone = this.getDiscloseNone(component, bean);
        boolean disclosedFixed = false;
        if (discloseMany && !discloseNone) {
            UIComponent child;
            int disclosedCount = 0;
            Iterator i$ = component.getChildren().iterator();
            while (!(!i$.hasNext() || (child = (UIComponent)i$.next()) instanceof UIXShowDetail && child.isRendered() && (detailItem = (UIXShowDetail)child).isDisclosed() && ++disclosedCount > 1)) {
            }
            if (disclosedCount <= 1) {
                disclosedFixed = true;
            }
        }
        boolean childAlreadyRendered = false;
        for (UIComponent child : component.getChildren()) {
            boolean disclosable;
            boolean javaScriptSupport;
            if (!(child instanceof UIXShowDetail) || !child.isRendered()) continue;
            detailItem = (UIXShowDetail)child;
            boolean disabled = this._isItemDisabled((UIComponent)detailItem);
            String titleText = (String)detailItem.getAttributes().get(CoreShowDetailItem.TEXT_KEY.getName());
            boolean disclosed = detailItem.isDisclosed();
            if (childAlreadyRendered) {
                disclosed = false;
            }
            out.startElement("div", (UIComponent)detailItem);
            String detailItemId = detailItem.getClientId(context);
            String itemStyleClass = disabled ? this.getHeaderDisabledStyleClass() : (disclosed ? this.getHeaderExpandedStyleClass() : this.getHeaderCollapsedStyleClass());
            PanelAccordionRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)itemStyleClass);
            UIComponent toolbar = PanelAccordionRenderer.getFacet((UIComponent)detailItem, (String)"toolbar");
            if (toolbar != null) {
                out.startElement("div", (UIComponent)detailItem);
                PanelAccordionRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)"af|panelAccordion::toolbar");
                this.encodeChild(context, toolbar);
                out.endElement("div");
            }
            if (javaScriptSupport = PanelAccordionRenderer.supportsScripting(rc)) {
                out.startElement("a", null);
                out.writeAttribute("name", (Object)detailItemId, null);
            } else {
                out.startElement("input", null);
                out.writeAttribute("type", (Object)"submit", null);
            }
            PanelAccordionRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)(disabled ? this.getLinkDisabledStyleClass() : this.getLinkEnabledStyleClass()));
            boolean bl = disclosable = discloseNone || !disclosed || discloseMany && !disclosedFixed;
            if (disclosable && !disabled) {
                String event;
                boolean isImmediate = detailItem.isImmediate();
                String string = event = disclosed ? "hide" : "show";
                if (javaScriptSupport) {
                    String onClickHandler = this._getFormSubmitScript(component, rc, event, detailItemId, formName, compId, isImmediate);
                    out.writeAttribute("onclick", (Object)onClickHandler, null);
                    out.writeAttribute("href", (Object)"#", null);
                } else {
                    String nameAttri = XhtmlUtils.getEncodedParameter("source") + XhtmlUtils.getEncodedParameter(compId) + XhtmlUtils.getEncodedParameter("event") + XhtmlUtils.getEncodedParameter(event) + XhtmlUtils.getEncodedParameter("targetItem") + detailItemId;
                    out.writeAttribute("name", (Object)nameAttri, null);
                }
            }
            if (javaScriptSupport) {
                if (!disabled) {
                    ShowDetailRenderer.renderDisclosureIcon(context, rc, disclosed, this.getDisclosedTipKey(), this.getUndisclosedTipKey());
                }
                if (titleText != null) {
                    out.writeText((Object)titleText, null);
                }
                out.endElement("a");
            } else {
                String icon;
                String string = icon = disclosed ? "-" : "+";
                if (titleText != null) {
                    icon = icon + titleText;
                }
                out.writeAttribute("value", (Object)icon, null);
                if (disabled || !disclosable) {
                    out.writeAttribute("disabled", (Object)Boolean.TRUE, "disabled");
                }
                out.endElement("input");
            }
            out.endElement("div");
            if (!disclosed || disabled || childAlreadyRendered) continue;
            this._encodeDetailItem(context, rc, component, detailItem, out);
            if (discloseMany) continue;
            childAlreadyRendered = true;
        }
        out.endElement("div");
    }

    @Override
    protected String getDefaultStyleClass(UIComponent component, FacesBean bean) {
        return "af|panelAccordion";
    }

    protected String getContentStyleClass() {
        return "af|panelAccordion::content";
    }

    protected String getHeaderDisabledStyleClass() {
        return "af|panelAccordion::header-disabled";
    }

    protected String getHeaderExpandedStyleClass() {
        return "af|panelAccordion::header-expanded";
    }

    protected String getHeaderCollapsedStyleClass() {
        return "af|panelAccordion::header-collapsed";
    }

    protected String getLinkDisabledStyleClass() {
        return "af|panelAccordion::title-disabled-link";
    }

    protected String getLinkEnabledStyleClass() {
        return "af|panelAccordion::title-link";
    }

    protected String getDisclosedTipKey() {
        return _DISCLOSED_TIP_KEY;
    }

    protected String getUndisclosedTipKey() {
        return _UNDISCLOSED_TIP_KEY;
    }

    private void _encodeDetailItem(FacesContext context, RenderingContext rc, UIComponent component, UIXShowDetail detailItem, ResponseWriter out) throws IOException {
        out.startElement("table", component);
        out.writeAttribute("cellSpacing", (Object)"0", null);
        out.writeAttribute("cellPadding", (Object)"0", null);
        out.writeAttribute("summary", (Object)"", null);
        PanelAccordionRenderer.renderStyleClass((FacesContext)context, (RenderingContext)rc, (String)this.getContentStyleClass());
        out.startElement("tr", component);
        out.startElement("td", component);
        this.encodeChild(context, (UIComponent)detailItem);
        out.endElement("td");
        out.endElement("tr");
        out.endElement("table");
    }

    private String _getFormSubmitScript(UIComponent component, RenderingContext rc, String event, String detailItemId, String formName, String compId, boolean isImmediate) {
        String onClickHandler = "";
        boolean pprEnabled = PartialPageUtils.supportsPartialRendering(rc);
        String validate = "1";
        if (isImmediate) {
            validate = "0";
        }
        if (pprEnabled) {
            StringBuilder onClickHandlerBuff = new StringBuilder("_submitPartialChange('").append(formName).append("',").append(validate).append(", {event:'").append(event).append("',source:'").append(compId).append("',targetItem:'").append(detailItemId).append("'});return false;");
            onClickHandler = onClickHandlerBuff.toString();
        } else {
            StringBuilder onClickHandlerBuff = new StringBuilder("submitForm('").append(formName).append("',").append(validate).append(", {event:'").append(event).append("',source:'").append(compId).append("',targetItem:'").append(detailItemId).append("'});return false;");
            onClickHandler = onClickHandlerBuff.toString();
        }
        return onClickHandler;
    }

    protected boolean getDiscloseMany(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._discloseManyKey);
        if (o == null) {
            o = this._discloseManyKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected boolean getDiscloseNone(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._discloseNoneKey);
        if (o == null) {
            o = this._discloseNoneKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    private boolean _isItemDisabled(UIComponent component) {
        Object isDisabled = component.getAttributes().get(CoreShowDetailItem.DISABLED_KEY.getName());
        return Boolean.TRUE.equals(isDisabled);
    }
}

