/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.PageFlowScopeProvider;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.pages.FredJSP;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.PartialPageUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.DialogStyleScriptlet;

class DialogRequest {
    private final String _clientId;
    private final String _formId;
    private final String _url;
    private final boolean _usePopup;
    private final Map<String, Object> _dialogProperties;
    private static final String _DEFAULT_WIDTH = "100";
    private static final String _DEFAULT_HEIGHT = "100";
    private static int _sCount = 0;

    public DialogRequest(UIViewRoot targetRoot, String clientId, String formId, Map<String, Object> dialogProperties, boolean usePopup) {
        this._clientId = clientId;
        this._formId = formId;
        this._usePopup = usePopup;
        if (dialogProperties == null) {
            dialogProperties = Collections.emptyMap();
        }
        Object width = dialogProperties.get("width");
        Object height = dialogProperties.get("height");
        FacesContext context = FacesContext.getCurrentInstance();
        String url = usePopup ? context.getApplication().getViewHandler().getActionURL(context, targetRoot.getViewId()) : FredJSP.getRedirectURL(context, targetRoot, CoreRenderer.toString((Object)width), CoreRenderer.toString((Object)height));
        PageFlowScopeProvider provider = RequestContext.getCurrentInstance().getPageFlowScopeProvider();
        this._url = context.getExternalContext().encodeActionURL(provider.encodeDialogPageFlowScopeURL(context, url));
        this._dialogProperties = dialogProperties;
    }

    public static void addDependencies(FacesContext context, RenderingContext arc) throws IOException {
        XhtmlUtils.addLib(context, arc, "_launchDialog()");
    }

    public void renderLaunchJavascript(FacesContext context, RenderingContext arc) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        String formName = this._formId;
        if (this._usePopup) {
            DialogStyleScriptlet.outputStyleMapForDialog(context, arc);
            out.writeText((Object)"TrPopupDialog._launchDialog(\"", null);
        } else {
            out.writeText((Object)"_launchDialog(\"", null);
        }
        out.writeText((Object)this._url, null);
        if (!this._usePopup) {
            out.writeText((Object)"\", \"", null);
            out.writeText((Object)DialogRequest._getDialogWindowName(), null);
        }
        out.writeText((Object)"\",{", null);
        boolean writtenOne = false;
        if (!this._usePopup) {
            if (!this._dialogProperties.containsKey("width")) {
                out.writeText((Object)"width:", null);
                out.writeText((Object)"100", null);
                writtenOne = true;
            }
            if (!this._dialogProperties.containsKey("height")) {
                if (writtenOne) {
                    out.writeText((Object)",", null);
                } else {
                    writtenOne = true;
                }
                out.writeText((Object)"height:", null);
                out.writeText((Object)"100", null);
            }
        }
        for (String key : this._dialogProperties.keySet()) {
            Object value = this._dialogProperties.get(key);
            if (value == null) continue;
            if (writtenOne) {
                out.writeText((Object)",", null);
            } else {
                writtenOne = true;
            }
            out.writeText((Object)key, null);
            out.writeText((Object)":'", null);
            out.writeText(value, null);
            out.writeText((Object)"'", null);
        }
        out.writeText((Object)"},", null);
        if (this._usePopup) {
            out.writeText((Object)"TrPopupDialog._returnFromDialogAndSubmit, {'formName':'", null);
            out.writeText((Object)formName, null);
            out.writeText((Object)"'", null);
            if (this._clientId != null) {
                out.writeText((Object)",'postback':'", null);
                out.writeText((Object)this._clientId, null);
                out.writeText((Object)"'", null);
            }
            out.writeText((Object)"}", null);
        } else {
            out.writeText((Object)"\"", null);
            out.writeText((Object)formName, null);
            out.writeText((Object)"\",\"", null);
            if (this._clientId != null) {
                out.writeText((Object)this._clientId, null);
            }
            out.writeText((Object)"\"", null);
            boolean isPPR = PartialPageUtils.supportsPartialRendering(arc);
            out.writeText((Object)(isPPR ? ",1" : ",0"), null);
        }
        out.writeText((Object)");", null);
    }

    private static synchronized String _getDialogWindowName() {
        return "TrinidadDialog" + _sCount++;
    }
}

