/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.config.dispatch;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.myfaces.trinidad.context.Agent;
import org.apache.myfaces.trinidad.context.RenderingContext;

class ContentTypeAndCharacterSet {
    private String _contentType;
    private String _characterSet;
    private String _contentTypeAndCharset;
    private static final Pattern _CONTENT_TYPE_PATTERN = Pattern.compile("([^;]+)(?:;charset=(.*))?");

    ContentTypeAndCharacterSet(String contentTypeAndCharset) {
        Matcher matcher;
        if (contentTypeAndCharset != null && (matcher = _CONTENT_TYPE_PATTERN.matcher(contentTypeAndCharset)).matches()) {
            Agent agent;
            this._contentType = matcher.group(1);
            String string = this._characterSet = matcher.groupCount() > 1 ? matcher.group(2) : null;
            if ("application/xhtml+xml".equals(this._contentType) && (agent = RenderingContext.getCurrentInstance().getAgent()) != null && "ie".equals(agent.getAgentName())) {
                contentTypeAndCharset = "text/html";
                if (this._characterSet != null) {
                    contentTypeAndCharset = contentTypeAndCharset + ";charset=" + this._characterSet;
                }
            }
        }
        this._contentTypeAndCharset = contentTypeAndCharset;
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getCharacterSet() {
        return this._characterSet;
    }

    public String toString() {
        return this._contentTypeAndCharset;
    }
}

