/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo;

import javax.faces.event.ActionEvent;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.apache.myfaces.trinidad.context.RenderingContext;

public class SkinDirtyPhaseListener
implements PhaseListener {
    private boolean _pressedButton = false;

    public void afterPhase(PhaseEvent phaseEvent) {
    }

    public void beforePhase(PhaseEvent phaseEvent) {
        System.out.println("***PhaseTracker: After Phase: " + phaseEvent.getPhaseId());
        RenderingContext rContext = RenderingContext.getCurrentInstance();
        if (rContext != null) {
            System.out.println("Set Skin to dirty if button was pressed, and it is set to :" + this._pressedButton);
            if (this._pressedButton) {
                System.out.println("Setting the skin to be dirty will allow you to refresh your browser and see any changes to the skin's css file immediately.");
                rContext.getSkin().setDirty(true);
                this._pressedButton = false;
            } else {
                System.out.println("Set Skin to not be dirty");
                rContext.getSkin().setDirty(false);
            }
        } else {
            System.out.println("rContext in _afterPhase is null!");
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.RESTORE_VIEW;
    }

    public void buttonAction(ActionEvent action) {
        System.out.println("You pressed the button");
        this._pressedButton = true;
    }
}

