/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo.email;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.myfaces.trinidad.component.UIXTable;
import org.apache.myfaces.trinidad.event.RangeChangeEvent;
import org.apache.myfaces.trinidaddemo.email.FolderData;
import org.apache.myfaces.trinidaddemo.email.MessageData;
import org.apache.myfaces.trinidaddemo.email.MessageUtils;

public class MessagesBackingBean {
    private UIXTable _messagesTable;
    private FolderData _folderData;
    private static final Logger _LOG = Logger.getLogger(MessagesBackingBean.class.getName());

    public String compact() throws MessagingException {
        Folder folder = this._folderData.getFolder();
        folder.open(2);
        folder.expunge();
        folder.close(true);
        return this.refresh();
    }

    public String refresh() {
        this._folderData.flush();
        this.first();
        return null;
    }

    public void setFolder(FolderData folder) {
        this._folderData = folder;
    }

    public FolderData getFolder() {
        return this._folderData;
    }

    public void setMessagesTable(UIXTable table) {
        this._messagesTable = table;
    }

    public UIXTable getMessagesTable() {
        return this._messagesTable;
    }

    public boolean isFirstEnabled() {
        return this._messagesTable.getFirst() > 0;
    }

    public boolean isLastEnabled() {
        return this._messagesTable.getFirst() + this._messagesTable.getRows() < this._messagesTable.getRowCount();
    }

    public String first() {
        this._messagesTable.setFirst(0);
        return null;
    }

    public String last() {
        int lastRow = this._messagesTable.getRowCount() - 1;
        if (lastRow >= 0) {
            int rows = this._messagesTable.getRows();
            this._messagesTable.setFirst(lastRow / rows * rows);
        }
        return null;
    }

    public void saveFirst(RangeChangeEvent event) {
        this._folderData.setStartIndex(event.getNewStart());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performDelete(ActionEvent event) {
        Iterator selection = this._messagesTable.getSelectedRowKeys().iterator();
        if (selection.hasNext()) {
            try {
                Object oldRowKey = this._messagesTable.getRowKey();
                Folder folder = this._folderData.getFolder();
                folder.open(2);
                ArrayList<Message> messageList = new ArrayList<Message>();
                try {
                    while (selection.hasNext()) {
                        String rowKey = (String)selection.next();
                        this._messagesTable.setRowKey((Object)rowKey);
                        MessageData message = (MessageData)this._messagesTable.getRowData();
                        if (message == null) {
                            _LOG.log(Level.WARNING, "Couldn't find message for row {0}", rowKey);
                            continue;
                        }
                        _LOG.log(Level.FINE, "Attempting to delete message {0}", message.getSubject());
                        messageList.add(message.getMessage());
                    }
                    Message[] messages = messageList.toArray(new Message[messageList.size()]);
                    folder.setFlags(messages, new Flags(Flags.Flag.DELETED), true);
                    this._messagesTable.getSelectedRowKeys().clear();
                    this.refresh();
                }
                finally {
                    this._messagesTable.setRowKey(oldRowKey);
                    folder.close(false);
                }
            }
            catch (MessagingException me) {
                _LOG.log(Level.WARNING, "Couldn't delete", me);
                FacesContext context = FacesContext.getCurrentInstance();
                FacesMessage message = MessageUtils.getErrorMessage((FacesContext)context, (String)"COULD_NOT_DELETE", (Object[])new Object[]{me.getMessage()});
                context.addMessage(null, message);
            }
        } else {
            _LOG.fine("No messages were selected.");
        }
    }
}

