/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo.survey;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.trinidaddemo.survey.CheckboxQuestionBean;
import org.apache.myfaces.trinidaddemo.survey.MultChoiceQuestionBean;
import org.apache.myfaces.trinidaddemo.survey.QuestionBean;
import org.apache.myfaces.trinidaddemo.survey.SurveyPage;
import org.apache.myfaces.trinidaddemo.survey.TextQuestionBean;

public class SurveyBean
implements Serializable {
    private ArrayList<QuestionBean> _questions = new ArrayList();
    private int _currentIndex;
    private ArrayList<String> _userAnswers = new ArrayList();
    static final int NUMBER_OF_ANSWER_CHOICES = 4;
    private boolean debug = false;
    MultChoiceQuestionBean _q0;
    TextQuestionBean _q1;
    MultChoiceQuestionBean _q2;
    CheckboxQuestionBean _q3;
    MultChoiceQuestionBean _q4;
    String _a0;
    String _a1;
    String _a2;
    String _a3;
    boolean _a30;
    boolean _a31;
    boolean _a32;
    boolean _a33;
    String _a4;
    private List<SurveyPage> _pages;

    public SurveyBean() {
        this.init("survey.bundles.california");
    }

    public SurveyBean(String bundleName) {
        this.init(bundleName);
    }

    private void init(String bundleName) {
        this.loadQuestions();
        this.initSurveyState();
    }

    private void loadQuestions() {
        ArrayList<String> choices = new ArrayList<String>();
        choices.add("A. Loading zone for freight or passengers.");
        choices.add("B. Loading zone for passengers or mail only.");
        choices.add("C. Loading zone for freight only.");
        choices.add("D. They ran out of red paint.");
        this._q0 = new MultChoiceQuestionBean("A white painted curb means ", choices, 1);
        this._questions.add(this._q0);
        this._q1 = new TextQuestionBean("The color of a typical stop sign is ", "RED");
        this._questions.add(this._q1);
        ArrayList<String> choices2 = new ArrayList<String>();
        choices2.add("A. If the shoulder is wide enough to accommodate your vehicle.");
        choices2.add("B. If the vehicle ahead of you is turning left.");
        choices2.add("C. Under no circumstances.");
        choices2.add("D. If you are driving a Hummer.");
        this._q2 = new MultChoiceQuestionBean("You may drive off of the paved roadway to pass another vehicle ", choices2, 2);
        this._questions.add(this._q2);
        ArrayList<String> choices3 = new ArrayList<String>();
        choices3.add("A. In a crosswalk.");
        choices3.add("B. Within 10 feet of a fire hydrant.");
        choices3.add("C. Next to a red painted curb.");
        choices3.add("D. If you are driving a Hummer.");
        this._q3 = new CheckboxQuestionBean("It is illegal to park your vehicle (check all that apply) ", choices3, 14, true, true, true, false);
        this._questions.add(this._q3);
        ArrayList<String> choices4 = new ArrayList<String>();
        choices4.add("A. Stop, then proceed when you think all of the children have exited the bus.");
        choices4.add("B. Slow to 25 MPH and pass cautiously.");
        choices4.add("C. Stop as long as the red lights are flashing. ");
        choices4.add("D. Grab your sack lunch and jump onboard so you're not late for homeroom like yesterday.");
        this._q4 = new MultChoiceQuestionBean("A school bus ahead of you in your lane is stopped with red lights flashing. You should ", choices4, 2);
        this._questions.add(this._q4);
        if (this.debug) {
            System.out.println("init() printing out the list of questions:\n" + this._questions);
            System.out.println("length of list of questions: " + this._questions.size());
        }
    }

    public void initSurveyState() {
        this._currentIndex = 0;
        this._a0 = null;
        this._a1 = "";
        this._a2 = null;
        this._a3 = "0";
        this._a30 = false;
        this._a31 = false;
        this._a32 = false;
        this._a33 = false;
        this._a4 = null;
        this._userAnswers.add(this._a0);
        this._userAnswers.add(this._a1);
        this._userAnswers.add(this._a2);
        this._userAnswers.add(this._a3);
        this._userAnswers.add(this._a4);
    }

    public String next() {
        this.advanceToNextQuestion();
        if (this.debug) {
            System.out.println("the currentIndex is:" + this._currentIndex);
            System.out.println("next() is finished");
        }
        return "next";
    }

    public String back() {
        this.goToPreviousQuestion();
        if (this.debug) {
            System.out.println("the currentIndex is:" + this._currentIndex);
            System.out.println("next() is finished");
        }
        return "back";
    }

    public String finish() {
        return "finish";
    }

    public String check() {
        return "check";
    }

    public String start() {
        this.initSurveyState();
        return "start";
    }

    public String getNumQuestions() {
        return String.valueOf(this._questions.size());
    }

    public boolean getDone() {
        return this._currentIndex == this._questions.size() - 1;
    }

    public String getCurrentQuestionNumber() {
        int i = this._currentIndex + 1;
        return String.valueOf(i);
    }

    public void advanceToNextQuestion() {
        ++this._currentIndex;
    }

    public void goToPreviousQuestion() {
        --this._currentIndex;
    }

    public String getError() {
        return "error";
    }

    public String getNone() {
        return "none";
    }

    public String getEmptyString() {
        return "";
    }

    public String getCorrect() {
        return "correct";
    }

    public String getIncorrect() {
        return "incorrect";
    }

    private String storeCheckSelection(boolean checked, int index, String storageDestination) {
        int storageInt = Integer.parseInt(storageDestination);
        storageInt = checked ? (storageInt |= 1 << 4 - index - 1) : (storageInt &= ~(1 << 4 - index - 1));
        if (this.debug) {
            System.out.println("checked is: " + checked + ", index is: " + index + ", storageInt is:" + storageInt);
        }
        return String.valueOf(storageInt);
    }

    public MultChoiceQuestionBean getQ0() {
        return this._q0;
    }

    public TextQuestionBean getQ1() {
        return this._q1;
    }

    public MultChoiceQuestionBean getQ2() {
        return this._q2;
    }

    public CheckboxQuestionBean getQ3() {
        return this._q3;
    }

    public MultChoiceQuestionBean getQ4() {
        return this._q4;
    }

    public void setA0(String a0) {
        this._a0 = a0;
    }

    public String getA0() {
        return this._a0;
    }

    public void setA1(String a1) {
        this._a1 = a1.trim().toUpperCase();
    }

    public String getA1() {
        return this._a1;
    }

    public void setA2(String a2) {
        this._a2 = a2;
    }

    public String getA2() {
        return this._a2;
    }

    public void setA3(String a3) {
        this._a3 = a3;
    }

    public String getA3() {
        return this._a3;
    }

    public void setA4(String a4) {
        this._a4 = a4;
    }

    public String getA4() {
        return this._a4;
    }

    public void setA30(boolean a30) {
        this._a30 = a30;
        this._a3 = this.storeCheckSelection(a30, 0, this._a3);
    }

    public boolean getA30() {
        return this._a30;
    }

    public void setA31(boolean a31) {
        this._a31 = a31;
        this._a3 = this.storeCheckSelection(a31, 1, this._a3);
    }

    public boolean getA31() {
        return this._a31;
    }

    public void setA32(boolean a32) {
        this._a32 = a32;
        this._a3 = this.storeCheckSelection(a32, 2, this._a3);
    }

    public boolean getA32() {
        return this._a32;
    }

    public void setA33(boolean a33) {
        this._a33 = a33;
        this._a3 = this.storeCheckSelection(a33, 3, this._a3);
    }

    public boolean getA33() {
        return this._a33;
    }

    public List<SurveyPage> getPages() {
        if (this._pages == null) {
            this._pages = new ArrayList();
            this._pages.add(new SurveyPage("/surveydemo/surveyPage1.jspx", "Step1"));
            this._pages.add(new SurveyPage("/surveydemo/surveyPage2.jspx", "Step2"));
            this._pages.add(new SurveyPage("/surveydemo/surveyPage3.jspx", "Step3"));
            this._pages.add(new SurveyPage("/surveydemo/surveyPage4.jspx", "Step4"));
            this._pages.add(new SurveyPage("/surveydemo/surveyPage5.jspx", "Step5"));
        }
        return this._pages;
    }
}

