/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UISelectItems;
import javax.faces.event.ValueChangeEvent;
import javax.faces.model.SelectItem;
import org.apache.myfaces.trinidad.component.UIXOutput;
import org.apache.myfaces.trinidad.component.core.nav.CoreCommandLink;
import org.apache.myfaces.trinidad.event.ReturnEvent;
import org.apache.myfaces.trinidaddemo.CarBackingBean;
import org.apache.myfaces.trinidaddemo.CarOption;

public class CarBackingBean {
    private UIXOutput _price;
    private UIXOutput _options;
    private CoreCommandLink _launchOptions;
    private UISelectItems _modelItems;
    private static final List<SelectItem> _MAKE_ITEMS = new ArrayList();
    private static final List<SelectItem> _CORDERA_MODELS = new ArrayList();
    private static final List<SelectItem> _AUTUMNO_MODELS = new ArrayList();
    private static final List<SelectItem> _GRABOWSKI_MODELS = new ArrayList();
    private static final Map<String, Integer> _PRICES = new HashMap();
    private static final SelectItem _NULL_SELECT_ITEM = new SelectItem((Object)"");

    public List<SelectItem> getMakes() {
        return _MAKE_ITEMS;
    }

    public void makeChanged(ValueChangeEvent vce) {
        Object newValue;
        if ("".equals(vce.getNewValue())) {
            this._modelItems.setValue((Object)Collections.EMPTY_LIST);
        }
        if ((newValue = vce.getNewValue()) instanceof Car) {
            String newCar = ((Car)newValue).getName();
            if ("cordera".equals(newCar)) {
                this._modelItems.setValue((Object)_CORDERA_MODELS);
            } else if ("autumno".equals(newCar)) {
                this._modelItems.setValue((Object)_AUTUMNO_MODELS);
            } else if ("grabowski".equals(newCar)) {
                this._modelItems.setValue((Object)_GRABOWSKI_MODELS);
            }
        }
        this._options.setValue(null);
        this._price.setValue(null);
        this._launchOptions.setDisabled(true);
    }

    public void modelChanged(ValueChangeEvent vce) {
        this._price.setValue(this._getPriceOfCar(vce.getNewValue()));
        this._options.setValue(null);
        this._launchOptions.setDisabled("".equals(vce.getNewValue()));
    }

    public UISelectItems getModelItems() {
        return this._modelItems;
    }

    public void setModelItems(UISelectItems modelItems) {
        this._modelItems = modelItems;
    }

    public UIXOutput getPrice() {
        return this._price;
    }

    public void setPrice(UIXOutput price) {
        this._price = price;
    }

    public UIXOutput getOptions() {
        return this._options;
    }

    public void setOptions(UIXOutput options) {
        this._options = options;
    }

    public CoreCommandLink getLaunchOptions() {
        return this._launchOptions;
    }

    public void setLaunchOptions(CoreCommandLink launchOptions) {
        this._launchOptions = launchOptions;
    }

    public Object _getPriceOfCar(Object model) {
        return _PRICES.get(model);
    }

    public void returnOptions(ReturnEvent event) {
        Object value = event.getReturnValue();
        StringBuffer buffer = new StringBuffer();
        int addedPrice = 0;
        if (value instanceof List) {
            for (CarOption option : (List)value) {
                addedPrice += option.getPrice();
                if (buffer.length() != 0) {
                    buffer.append(", ");
                }
                buffer.append(option.getName());
            }
        }
        this._options.setValue((Object)buffer.toString());
        Integer price = (Integer)this._price.getValue();
        this._price.setValue((Object)new Integer(price + addedPrice));
    }

    static {
        _MAKE_ITEMS.add(_NULL_SELECT_ITEM);
        _MAKE_ITEMS.add(new SelectItem((Object)new Car("cordera"), "Cordera Ltd."));
        _MAKE_ITEMS.add(new SelectItem((Object)new Car("autumno"), "Autumno Inc."));
        _MAKE_ITEMS.add(new SelectItem((Object)new Car("grabowski"), "Grabowski Motors"));
        _CORDERA_MODELS.add(_NULL_SELECT_ITEM);
        _CORDERA_MODELS.add(new SelectItem((Object)"XL", "XL"));
        _CORDERA_MODELS.add(new SelectItem((Object)"SV", "SV"));
        _CORDERA_MODELS.add(new SelectItem((Object)"DUH", "DUH"));
        _AUTUMNO_MODELS.add(_NULL_SELECT_ITEM);
        _AUTUMNO_MODELS.add(new SelectItem((Object)"390"));
        _AUTUMNO_MODELS.add(new SelectItem((Object)"490"));
        _AUTUMNO_MODELS.add(new SelectItem((Object)"585"));
        _GRABOWSKI_MODELS.add(_NULL_SELECT_ITEM);
        _GRABOWSKI_MODELS.add(new SelectItem((Object)"OneAndOnly"));
        _PRICES.put("XL", new Integer(25000));
        _PRICES.put("SV", new Integer(17000));
        _PRICES.put("DUH", new Integer(12000));
        _PRICES.put("390", new Integer(29500));
        _PRICES.put("490", new Integer(39500));
        _PRICES.put("585", new Integer(49500));
        _PRICES.put("OneAndOnly", new Integer(116500));
    }
}

