/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo.tableDemos;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.trinidad.component.UIXTable;

public class CSVBean {
    private UIXTable _table;

    public void sendContent(FacesContext context, OutputStream out) throws IOException {
        OutputStreamWriter outw = new OutputStreamWriter(out, "UTF-8");
        UIXTable table = this.getTable();
        Object rowKey = table.getRowKey();
        for (int i = 0; i < table.getRowCount(); ++i) {
            table.setRowIndex(i);
            if (!table.isRowAvailable()) break;
            this._exportRow(table, (Writer)outw);
        }
        ((Writer)outw).flush();
        table.setRowKey(rowKey);
    }

    private void _exportRow(UIXTable table, Writer out) throws IOException {
        List children = table.getChildren();
        boolean needsComma = false;
        for (Object o : children) {
            UIComponent child = (UIComponent)o;
            if (!child.isRendered()) continue;
            if (needsComma) {
                out.write(44);
            }
            if (!this._exportCell(child, out)) continue;
            needsComma = true;
        }
        out.write(10);
    }

    private boolean _exportCell(UIComponent cell, Writer out) throws IOException {
        boolean foundValue = false;
        if (cell instanceof ValueHolder) {
            foundValue = true;
            Object value = ((ValueHolder)cell).getValue();
            if (value != null) {
                String valueStr;
                Converter converter = ((ValueHolder)cell).getConverter();
                if (converter != null) {
                    try {
                        valueStr = converter.getAsString(FacesContext.getCurrentInstance(), cell, value);
                    }
                    catch (ConverterException ce) {
                        valueStr = value.toString();
                    }
                } else {
                    valueStr = value.toString();
                }
                if (valueStr != null) {
                    out.write(34);
                    out.write(this._csvEscape(valueStr));
                    out.write(34);
                }
            }
        }
        if (cell.getChildCount() > 0) {
            List children = cell.getChildren();
            for (Object o : children) {
                UIComponent child = (UIComponent)o;
                if (!child.isRendered() || !this._exportCell(child, out)) continue;
                foundValue = true;
            }
        }
        return foundValue;
    }

    public UIXTable getTable() {
        return this._table;
    }

    public void setTable(UIXTable table) {
        this._table = table;
    }

    private String _csvEscape(String value) {
        if (value.indexOf(34) >= 0) {
            return value.replace("\\\"", "\\\"\\\"");
        }
        return value;
    }
}

