/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo.email;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;

public class MessageData {
    private static final String _PLAIN_TEXT = "TEXT/PLAIN";
    private static final String _HTML_TEXT = "TEXT/HTML";
    private static final String _MULTIPART = "multipart";
    private final Message _message;
    private Object _content = null;
    private String _contentType = null;
    private int _lineCount = -1;
    private int _size;
    private boolean _isRead;
    private boolean _isDeleted;
    private List<BodyPart> _attachments;

    public MessageData(Message message) throws MessagingException {
        this._message = message;
        this._size = message.getSize() / 1024;
        this._isRead = this._message.isSet(Flags.Flag.SEEN);
        this._isDeleted = this._message.isSet(Flags.Flag.DELETED);
    }

    public int getMessageNumber() {
        return this._message.getMessageNumber();
    }

    public Address getSender() throws MessagingException {
        return this._message.getFrom()[0];
    }

    public String getSubject() throws MessagingException {
        String subject = this._message.getSubject();
        if (subject == null || "".equals(subject)) {
            subject = "<empty>";
        }
        return subject;
    }

    public int getSize() {
        return this._size;
    }

    public Date getSentDate() throws MessagingException {
        return this._message.getSentDate();
    }

    public Address[] getTos() throws MessagingException {
        Address[] tos = this._message.getRecipients(Message.RecipientType.TO);
        return tos;
    }

    public Address[] getCcs() throws MessagingException {
        Address[] ccs = this._message.getRecipients(Message.RecipientType.CC);
        return ccs;
    }

    public String getContentType() throws MessagingException {
        try {
            this._tryInit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._contentType;
    }

    public Object getContent() throws MessagingException, IOException {
        try {
            this._tryInit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._content;
    }

    public int getLineCount() throws MessagingException {
        try {
            this._tryInit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._lineCount;
    }

    public boolean isRead() {
        return this._isRead;
    }

    public boolean isDeleted() {
        return this._isDeleted;
    }

    public Message getMessage() {
        return this._message;
    }

    public List<BodyPart> getAttachments() {
        return this._attachments;
    }

    public boolean isAttachmentPresent() {
        return this._attachments != null && !this._attachments.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _tryInit() throws MessagingException, IOException {
        if (this._lineCount == -1) {
            int count = 0;
            String contentType = null;
            Object content = null;
            this._message.getFolder().open(this._isRead ? 1 : 2);
            ArrayList<BodyPart> attachments = new ArrayList<BodyPart>();
            try {
                int index;
                count = this._message.getLineCount();
                contentType = this._message.getContentType();
                content = this._message.getContent();
                if (contentType.startsWith(_MULTIPART) && content instanceof MimeMultipart) {
                    boolean found = false;
                    MimeMultipart mm = (MimeMultipart)content;
                    for (int i = 0; i < mm.getCount(); ++i) {
                        MimeBodyPart mbp;
                        String type;
                        BodyPart bp = mm.getBodyPart(i);
                        if (!found && bp instanceof MimeBodyPart && ((type = (mbp = (MimeBodyPart)bp).getContentType()).startsWith(_HTML_TEXT) || type.startsWith(_PLAIN_TEXT))) {
                            found = true;
                            count = mbp.getLineCount();
                            content = mbp.getContent();
                            contentType = type;
                            continue;
                        }
                        String disp = bp.getDisposition();
                        if (disp != null && !disp.equalsIgnoreCase("attachment")) continue;
                        attachments.add(bp);
                    }
                    if (!found) {
                        if (!attachments.isEmpty()) {
                            content = "";
                        } else {
                            throw new IllegalStateException();
                        }
                    }
                }
                if ((index = contentType.indexOf(59)) != -1) {
                    contentType = contentType.substring(0, index);
                }
                this._message.getFlags().add(Flags.Flag.SEEN);
                this._isRead = true;
            }
            catch (Exception e) {
                content = "Error trying to display content";
                count = 1;
                contentType = _PLAIN_TEXT;
                attachments.clear();
            }
            finally {
                this._message.getFolder().close(false);
            }
            this._lineCount = count;
            this._contentType = contentType;
            this._content = content;
            this._attachments = attachments;
        }
    }
}

