/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo.email;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.model.ChildPropertyTreeModel;
import org.apache.myfaces.trinidad.model.TreeModel;
import org.apache.myfaces.trinidaddemo.email.FolderData;
import org.apache.myfaces.trinidaddemo.email.PreferencesData;

public final class AccountData
implements Serializable {
    private String _username;
    private String _password;
    private String _domain;
    private String _server;
    private String _smtpServer;
    private transient Store _store;
    private transient TreeModel _folderModel;
    private transient FolderData[] _rootFolders;
    private transient PreferencesData _preferences;
    private static final Logger _LOG = Logger.getLogger(AccountData.class.getName());

    public AccountData() {
        this._initializeFromProperties();
    }

    public String getUsername() {
        return this._username;
    }

    public String getDomain() {
        return this._domain;
    }

    public String getServer() {
        return this._server;
    }

    public String getSmtpServer() {
        return this._smtpServer;
    }

    public String getPassword() {
        return this._password;
    }

    public Store getStore() {
        return this._store;
    }

    public FolderData getCurrentFolder() {
        RequestContext afContext = RequestContext.getCurrentInstance();
        return (FolderData)afContext.getPageFlowScope().get("currentFolder");
    }

    public FolderData[] getRootFolders() {
        return this._rootFolders;
    }

    public PreferencesData getPreferences() {
        return this._preferences;
    }

    public TreeModel getFolderModel() {
        return this._folderModel;
    }

    public void setUsername(String userName) {
        this._username = userName;
    }

    public void setDomain(String domain) {
        this._domain = domain;
    }

    public void setServer(String server) {
        this._server = server;
    }

    public void setSmtpServer(String smtpServer) {
        this._smtpServer = smtpServer;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setStore(Store store) {
        this._store = store;
    }

    public void setCurrentFolder(FolderData folderData) {
        RequestContext afContext = RequestContext.getCurrentInstance();
        afContext.getPageFlowScope().put("currentFolder", folderData);
    }

    public void setRootFolders(FolderData[] rootFolders) {
        this._rootFolders = rootFolders;
        List<Object> rootFolderList = Arrays.asList((Object[])this._rootFolders);
        ChildPropertyTreeModel folderTreeModel = new ChildPropertyTreeModel(rootFolderList, "subFolders");
        this.setFolderModel((TreeModel)folderTreeModel);
    }

    public void setPreferences(PreferencesData preferences) throws MessagingException {
        this._preferences = preferences;
    }

    public void setFolderModel(TreeModel model) {
        this._folderModel = model;
    }

    public String login() {
        try {
            Properties props = new Properties();
            Session session = Session.getInstance((Properties)props, null);
            Store store = session.getStore("imap");
            store.connect(this._server, this._username, this._password);
            this.setStore(store);
            this.setRootFolders(FolderData.toFolderData((AccountData)this, (Folder[])store.getDefaultFolder().list()));
            this._gotoFolder(null);
            PreferencesData preferences = new PreferencesData();
            this.setPreferences(preferences);
        }
        catch (Exception e) {
            FacesMessage errorMessage = new FacesMessage(FacesMessage.SEVERITY_ERROR, e.getMessage(), null);
            FacesContext context = FacesContext.getCurrentInstance();
            context.addMessage(null, errorMessage);
            return null;
        }
        return "success";
    }

    public String logout() {
        this.destroy();
        this.setCurrentFolder(null);
        this._password = null;
        this._folderModel = null;
        this._rootFolders = null;
        this._preferences = null;
        return "loggedOut";
    }

    public synchronized void destroy() {
        if (this._store != null) {
            try {
                this._store.close();
                this._store = null;
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    private void _gotoFolder(String newFolder) throws MessagingException {
        if (newFolder == null) {
            newFolder = "INBOX";
        }
        Folder folder = this.getStore().getFolder(newFolder);
        FolderData fdata = new FolderData(this, folder);
        this.setCurrentFolder(fdata);
    }

    private void _initializeFromProperties() {
        String home = System.getProperty("user.home");
        File file = new File(home, "trinidad-email-demo.properties");
        _LOG.log(Level.FINE, "Loading properties from {0}", file);
        try {
            FileInputStream stream = new FileInputStream(file);
            Properties properties = new Properties();
            properties.load(stream);
            this.setUsername(properties.getProperty("username"));
            this.setDomain(properties.getProperty("domain"));
            this.setServer(properties.getProperty("server"));
            String smtp = properties.getProperty("smtpserver");
            if (smtp == null) {
                smtp = System.getProperty("mail.smtp.host");
            }
            this.setSmtpServer(properties.getProperty("smtpserver"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

