/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo.dialog;

import java.util.Date;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.component.UIXCommand;
import org.apache.myfaces.trinidad.component.UIXInput;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.LaunchEvent;
import org.apache.myfaces.trinidad.event.PollEvent;
import org.apache.myfaces.trinidad.event.ReturnEvent;

public class LaunchDialogBean {
    private UIXInput _input;
    private UIXInput _tableInput;
    private UIXCommand _dummyCommand;

    public UIXInput getInput() {
        return this._input;
    }

    public void setInput(UIXInput input) {
        this._input = input;
    }

    public void addParameter(LaunchEvent event) {
        Object value = this.getInput().getValue();
        if (value != null) {
            try {
                Integer i = Integer.valueOf(value.toString());
                event.getDialogParameters().put("value", i);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String doLaunch() {
        RequestContext afContext = RequestContext.getCurrentInstance();
        Map process = afContext.getPageFlowScope();
        process.put("lastLaunch", new Date());
        return "dialog:chooseInteger";
    }

    public void returned(ReturnEvent event) {
        String dialogViewId;
        if (event.getReturnValue() != null) {
            this.getInput().setSubmittedValue(null);
            this.getInput().setValue(event.getReturnValue());
            RequestContext afContext = RequestContext.getCurrentInstance();
            afContext.addPartialTarget((UIComponent)this.getInput());
            dialogViewId = "/demos/successDialog.jspx";
        } else {
            dialogViewId = "/demos/cancelledDialog.jspx";
        }
        FacesContext context = FacesContext.getCurrentInstance();
        UIViewRoot root = context.getApplication().getViewHandler().createView(context, dialogViewId);
        LaunchEvent launchEvent = new LaunchEvent((UIComponent)this.getDummyCommand(), root);
        launchEvent.getWindowProperties().put("width", "200");
        launchEvent.getWindowProperties().put("height", "100");
        this.addParameter(launchEvent);
        launchEvent.queue();
    }

    public void poll(PollEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        UIViewRoot root = context.getApplication().getViewHandler().createView(context, "/demos/simpleDialog.jspx");
        RequestContext afContext = RequestContext.getCurrentInstance();
        afContext.launchDialog(root, null, event.getComponent(), true, null);
        event.getComponent().setRendered(false);
    }

    public UIXInput getTableInput() {
        return this._tableInput;
    }

    public void setTableInput(UIXInput tableInput) {
        this._tableInput = tableInput;
    }

    public void tableReturned(ReturnEvent event) {
        if (event.getReturnValue() != null) {
            this.getTableInput().setValue(event.getReturnValue());
            RequestContext afContext = RequestContext.getCurrentInstance();
            afContext.addPartialTarget((UIComponent)this.getTableInput());
        }
    }

    public UIXCommand getDummyCommand() {
        return this._dummyCommand;
    }

    public void setDummyCommand(UIXCommand dummyCommand) {
        this._dummyCommand = dummyCommand;
    }
}

