/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo.composite;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.NumberConverter;
import javax.faces.render.Renderer;
import javax.faces.validator.LongRangeValidator;
import javax.faces.validator.Validator;
import org.apache.myfaces.trinidad.component.core.input.CoreInputText;

public class DateFieldAsRenderer
extends Renderer {
    public void decode(FacesContext context, UIComponent component) {
        this._addChildren(context, component);
        Map attrs = component.getAttributes();
        if (Boolean.TRUE.equals(attrs.get("readOnly")) || Boolean.TRUE.equals(attrs.get("disabled"))) {
            return;
        }
        EditableValueHolder evh = (EditableValueHolder)component;
        evh.setSubmittedValue((Object)Boolean.TRUE);
        component.getFacet("month").processDecodes(context);
        component.getFacet("year").processDecodes(context);
        component.getFacet("day").processDecodes(context);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) {
        EditableValueHolder monthComp = (EditableValueHolder)component.getFacet("month");
        EditableValueHolder yearComp = (EditableValueHolder)component.getFacet("year");
        EditableValueHolder dayComp = (EditableValueHolder)component.getFacet("day");
        if (!(monthComp.isValid() && yearComp.isValid() && dayComp.isValid())) {
            return null;
        }
        int year = ((Number)yearComp.getValue()).intValue();
        if (year < 70) {
            year += 100;
        }
        int month = ((Number)monthComp.getValue()).intValue() - 1;
        int day = ((Number)dayComp.getValue()).intValue();
        Date oldValue = (Date)((EditableValueHolder)component).getValue();
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(true);
        calendar.setTime(oldValue);
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        if (day != calendar.get(5)) {
            int numberOfDaysInMonth = day - calendar.get(5);
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, "Invalid date.", "This month only has " + numberOfDaysInMonth + " days!");
            throw new ConverterException(message);
        }
        return calendar.getTime();
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this._addChildren(context, component);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter out = context.getResponseWriter();
        UIComponent month = component.getFacet("month");
        month.encodeBegin(context);
        month.encodeChildren(context);
        month.encodeEnd(context);
        out.writeText((Object)"\u00a0/\u00a0", null);
        UIComponent day = component.getFacet("day");
        day.encodeBegin(context);
        day.encodeChildren(context);
        day.encodeEnd(context);
        out.writeText((Object)"\u00a0/\u00a0", null);
        UIComponent year = component.getFacet("year");
        year.encodeBegin(context);
        year.encodeChildren(context);
        year.encodeEnd(context);
    }

    public boolean getRendersChildren() {
        return true;
    }

    private void _addChildren(FacesContext context, UIComponent component) {
        if (component.getFacet("month") != null) {
            return;
        }
        String id = component.getId();
        if (id == null) {
            id = context.getViewRoot().createUniqueId();
            component.setId(id);
        }
        Map facets = component.getFacets();
        facets.clear();
        Date value = (Date)((EditableValueHolder)component).getValue();
        Calendar calendar = null;
        if (value != null) {
            calendar = Calendar.getInstance();
            calendar.setLenient(true);
            calendar.setTime(value);
        }
        CoreInputText month = this._createTwoDigitInput(context);
        month.setShortDesc("Month");
        month.setId(id + "_month");
        LongRangeValidator monthRange = this._createLongRangeValidator(context);
        monthRange.setMinimum(1L);
        monthRange.setMaximum(12L);
        month.addValidator((Validator)monthRange);
        if (value != null) {
            month.setValue((Object)new Integer(calendar.get(2) + 1));
        }
        facets.put("month", month);
        CoreInputText day = this._createTwoDigitInput(context);
        day.setShortDesc("Day");
        day.setId(id + "_day");
        LongRangeValidator dayRange = this._createLongRangeValidator(context);
        dayRange.setMinimum(1L);
        dayRange.setMaximum(31L);
        day.addValidator((Validator)dayRange);
        if (value != null) {
            day.setValue((Object)new Integer(calendar.get(5)));
        }
        facets.put("day", day);
        CoreInputText year = this._createTwoDigitInput(context);
        year.setShortDesc("Year");
        year.setId(id + "_year");
        if (value != null) {
            int yearValue = calendar.get(1) - 1900;
            if (yearValue >= 100) {
                yearValue -= 100;
            }
            year.setValue((Object)new Integer(yearValue));
        }
        facets.put("year", year);
    }

    private LongRangeValidator _createLongRangeValidator(FacesContext context) {
        return (LongRangeValidator)context.getApplication().createValidator("javax.faces.LongRange");
    }

    private CoreInputText _createTwoDigitInput(FacesContext context) {
        CoreInputText input = new CoreInputText();
        input.setColumns(2);
        input.setMaximumLength(2);
        input.setTransient(true);
        input.setRequired(true);
        input.setSimple(true);
        NumberConverter converter = (NumberConverter)context.getApplication().createConverter("javax.faces.Number");
        converter.setIntegerOnly(true);
        converter.setMaxIntegerDigits(2);
        converter.setMinIntegerDigits(2);
        input.setConverter((Converter)converter);
        return input;
    }
}

