/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo.composite;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.NumberConverter;
import javax.faces.event.FacesEvent;
import javax.faces.event.ValueChangeEvent;
import javax.faces.validator.LongRangeValidator;
import javax.faces.validator.Validator;
import org.apache.myfaces.trinidad.component.UIXEditableValue;
import org.apache.myfaces.trinidad.component.core.input.CoreInputText;
import org.apache.myfaces.trinidad.component.core.output.CoreOutputText;

public class DateField
extends UIXEditableValue
implements NamingContainer {
    private transient CoreInputText _month;
    private transient CoreInputText _year;
    private transient CoreInputText _day;

    public DateField() {
        super(null);
    }

    public void processDecodes(FacesContext context) {
        this._addChildren(context);
        super.processDecodes(context);
    }

    public void validate(FacesContext context) {
        if (!(this._month.isValid() && this._year.isValid() && this._day.isValid())) {
            this.setValid(false);
            return;
        }
        int year = ((Number)this._year.getValue()).intValue();
        if (year < 70) {
            year += 100;
        }
        int month = ((Number)this._month.getValue()).intValue() - 1;
        int day = ((Number)this._day.getValue()).intValue();
        Date oldValue = (Date)this.getValue();
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(true);
        calendar.setTime(oldValue);
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        if (day != calendar.get(5)) {
            int numberOfDaysInMonth = day - calendar.get(5);
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, "Invalid date.", "This month only has " + numberOfDaysInMonth + " days!");
            this.setValid(false);
            context.addMessage(this.getClientId(context), message);
        } else {
            this.setValid(true);
            Date newValue = calendar.getTime();
            if (!calendar.getTime().equals(oldValue)) {
                this.setValue((Object)newValue);
                this.queueEvent((FacesEvent)new ValueChangeEvent((UIComponent)this, (Object)oldValue, (Object)newValue));
            }
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this._addChildren(context);
        super.encodeBegin(context);
    }

    public void encodeChildren(FacesContext context) throws IOException {
        for (UIComponent child : this.getChildren()) {
            assert (child.getChildCount() == 0);
            assert (child.getFacets().isEmpty());
            child.encodeBegin(context);
            child.encodeChildren(context);
            child.encodeEnd(context);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    private void _addChildren(FacesContext context) {
        if (this._month != null) {
            return;
        }
        List children = this.getChildren();
        children.clear();
        Date value = (Date)this.getValue();
        Calendar calendar = null;
        if (value != null) {
            calendar = Calendar.getInstance();
            calendar.setLenient(true);
            calendar.setTime(value);
        }
        this._month = this._createTwoDigitInput(context);
        this._month.setId("month");
        this._month.setShortDesc("Month");
        LongRangeValidator monthRange = this._createLongRangeValidator(context);
        monthRange.setMinimum(1L);
        monthRange.setMaximum(12L);
        this._month.addValidator((Validator)monthRange);
        if (value != null) {
            this._month.setValue((Object)new Integer(calendar.get(2) + 1));
        }
        this._day = this._createTwoDigitInput(context);
        this._day.setId("day");
        this._day.setShortDesc("Day");
        LongRangeValidator dayRange = this._createLongRangeValidator(context);
        dayRange.setMinimum(1L);
        dayRange.setMaximum(31L);
        this._day.addValidator((Validator)dayRange);
        if (value != null) {
            this._day.setValue((Object)new Integer(calendar.get(5)));
        }
        this._year = this._createTwoDigitInput(context);
        this._year.setId("year");
        this._year.setShortDesc("Year");
        if (value != null) {
            int yearValue = calendar.get(1) - 1900;
            if (yearValue >= 100) {
                yearValue -= 100;
            }
            this._year.setValue((Object)new Integer(yearValue));
        }
        children.add(this._month);
        children.add(this._createSeparator(context));
        children.add(this._day);
        children.add(this._createSeparator(context));
        children.add(this._year);
    }

    private LongRangeValidator _createLongRangeValidator(FacesContext context) {
        return (LongRangeValidator)context.getApplication().createValidator("javax.faces.LongRange");
    }

    private CoreInputText _createTwoDigitInput(FacesContext context) {
        CoreInputText input = new CoreInputText();
        input.setColumns(2);
        input.setMaximumLength(2);
        input.setTransient(true);
        input.setRequired(true);
        input.setSimple(true);
        NumberConverter converter = (NumberConverter)context.getApplication().createConverter("javax.faces.Number");
        converter.setIntegerOnly(true);
        converter.setMaxIntegerDigits(2);
        converter.setMinIntegerDigits(2);
        input.setConverter((Converter)converter);
        return input;
    }

    private CoreOutputText _createSeparator(FacesContext context) {
        CoreOutputText output = new CoreOutputText();
        output.setValue((Object)"/");
        output.setTransient(true);
        return output;
    }
}

