/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo;

import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import org.apache.myfaces.trinidad.component.UIXOutput;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.model.UploadedFile;
import org.apache.myfaces.trinidaddemo.PartialDemoStatusBean;

public class PartialDemoUtilBean {
    private PartialDemoStatusBean _status;
    private UIXOutput _listUpdate;
    private Boolean _renderInputFileTemp;
    private static final String _RENDER_INPUT_FILE_KEY = PartialDemoUtilBean.class.getName() + ".renderInputFile";

    public void action(ActionEvent action) {
        this._status.setLinkUpdate();
    }

    public void reset(ActionEvent action) {
        this._status.reset();
        this._resetList();
    }

    public void prevalidateField() {
        this._status.incrementPrevalidateEventCount();
    }

    public void valueChanged(ValueChangeEvent vce) {
        Object newValue = vce.getNewValue();
        UIComponent component = vce.getComponent();
        String rendererType = component.getRendererType();
        if (rendererType.equals("org.apache.myfaces.trinidad.Checkbox")) {
            this._status.setChecked((Boolean)newValue);
            this._status.incrementCheckBoxUpdateCount();
        } else if (rendererType.equals("org.apache.myfaces.trinidad.Radio")) {
            if (Boolean.TRUE.equals(newValue)) {
                String text = (String)component.getAttributes().get("text");
                this._status.setSelectBooleanState(text);
            } else if (newValue instanceof String) {
                this._status.setSelectOneState((String)newValue);
            }
        } else if (rendererType.equals("org.apache.myfaces.trinidad.Text")) {
            if (newValue instanceof String) {
                this._status.setTextValue((String)newValue);
            }
        } else if (rendererType.equals("org.apache.myfaces.trinidad.Choice")) {
            if (newValue instanceof String) {
                this._status.setChoiceInt((String)newValue);
            }
        } else if (rendererType.equals("org.apache.myfaces.trinidad.Listbox")) {
            this._listUpdate.setValue(component.getAttributes().get("value"));
            this._addTarget((UIComponent)this._listUpdate);
        }
    }

    public UIXOutput getListUpdate() {
        return this._listUpdate;
    }

    public void setListUpdate(UIXOutput listUpdate) {
        this._listUpdate = listUpdate;
    }

    public PartialDemoStatusBean getStatus() {
        return this._status;
    }

    public void setStatus(PartialDemoStatusBean status) {
        this._status = status;
    }

    public void navigate(ValueChangeEvent vce) {
        Object newValue = vce.getNewValue();
        if (newValue != null && !"".equals(newValue)) {
            FacesContext fContext = FacesContext.getCurrentInstance();
            ViewHandler vh = fContext.getApplication().getViewHandler();
            UIViewRoot root = vh.createView(fContext, newValue.toString());
            fContext.setViewRoot(root);
        }
    }

    public void setRenderInputFile(boolean renderInputFile) {
        this._renderInputFileTemp = renderInputFile;
    }

    public boolean isRenderInputFile() {
        Boolean value = (Boolean)FacesContext.getCurrentInstance().getViewRoot().getViewMap().get(_RENDER_INPUT_FILE_KEY);
        return value != null && value != false;
    }

    public void fileUploaded(ValueChangeEvent event) {
        this._status.setUploadFile((UploadedFile)event.getNewValue());
    }

    public void updateRenderInputFileState(ActionEvent event) {
        FacesContext.getCurrentInstance().getViewRoot().getViewMap().put(_RENDER_INPUT_FILE_KEY, this._renderInputFileTemp);
        this._renderInputFileTemp = null;
    }

    private void _resetList() {
        this._listUpdate.setValue((Object)"nothing yet.");
        this._addTarget((UIComponent)this._listUpdate);
    }

    private void _addTarget(UIComponent target) {
        RequestContext adfContext = RequestContext.getCurrentInstance();
        adfContext.addPartialTarget(target);
    }
}

