/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.DisclosureEvent;

public class DemoShowDetailDisclosureBean {
    private String _disclosureKey = "ItemA";
    private static final List<String> KEYS = new ArrayList<String>(Arrays.asList("ItemA", "ItemB", "ItemC", "ItemD"));

    public List<String> getKeys() {
        return KEYS;
    }

    public void handleDisclosure(DisclosureEvent event) {
        String disclosureKey = (String)event.getComponent().getAttributes().get("disclosureKey");
        if (event.isExpanded()) {
            this.setDisclosureKey(disclosureKey);
        } else if (disclosureKey != null && disclosureKey.equals(this._disclosureKey)) {
            this.setDisclosureKey("ItemA");
        }
    }

    public void setDisclosureKey(String disclosureKey) {
        if (KEYS.contains(disclosureKey)) {
            this._disclosureKey = disclosureKey;
            System.out.println("Disclosure key set to: " + disclosureKey);
            RequestContext.getCurrentInstance().addPartialTarget(FacesContext.getCurrentInstance().getViewRoot().findComponent("panelHeader"));
        }
    }

    public String getDisclosureKey() {
        return this._disclosureKey;
    }
}

