/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.myfaces.trinidad.model.UploadedFile;

public class PartialDemoStatusBean
implements Serializable {
    private int _checkBoxUpdateCount;
    private int _prevalidateEventCount;
    private Boolean _checkBoxState;
    private Integer _choiceInt;
    private String _linkUpdate;
    private String _radioState;
    private String _textValue;
    private String _uploadFileState;
    private static String _NOTHING = "nothing yet.";
    private static String _DEFAULT_CHECK_STATE = "updates this text.";
    private static String _CHECKED_STATE = "is checked.";
    private static String _NOT_CHECKED_STATE = "is not checked.";
    private static String _DEFAULT_CHOICE_TEXT = _NOTHING;
    private static String _DEFAULT_LINK_UPDATE = "never.";
    private static String _DEFAULT_RADIO_STATE = "no selection yet.";
    private static String _DEFAULT_TEXT_STATE = _NOTHING;
    private static String _DEFAULT_TEXT_VALUE = "Change this text";
    private static String _DEFAULT_UPLOAD_FILE = "No file was uploaded";

    public PartialDemoStatusBean() {
        this.reset();
    }

    public boolean getChecked() {
        return Boolean.TRUE.equals(this._checkBoxState);
    }

    public int getCheckBoxUpdateCount() {
        return this._checkBoxUpdateCount;
    }

    public int getPrevalidateEventCount() {
        return this._prevalidateEventCount;
    }

    public String getCheckBoxStateText() {
        if (this._checkBoxState == null) {
            return _DEFAULT_CHECK_STATE;
        }
        if (Boolean.TRUE.equals(this._checkBoxState)) {
            return _CHECKED_STATE;
        }
        return _NOT_CHECKED_STATE;
    }

    public String getChoiceInt() {
        if (this._choiceInt == null) {
            return "1";
        }
        return this._choiceInt.toString();
    }

    public String getChoiceText() {
        if (this._choiceInt == null) {
            return _DEFAULT_CHOICE_TEXT;
        }
        return "value #" + this._choiceInt;
    }

    public String getLinkUpdate() {
        return this._linkUpdate;
    }

    public String getRadioStateText() {
        return this._radioState;
    }

    public String getTextStateText() {
        if (_DEFAULT_TEXT_VALUE.equals(this._textValue)) {
            return _DEFAULT_TEXT_STATE;
        }
        return this._textValue;
    }

    public String getTextValue() {
        return this._textValue;
    }

    public void setChecked(boolean checked) {
        this._checkBoxState = checked ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setChecked(Boolean checked) {
        this._checkBoxState = checked;
    }

    public void setChoiceText(String txt) {
    }

    public void setChoiceInt(String ci) {
        this._choiceInt = new Integer(ci);
    }

    public void setLinkUpdate() {
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
        this._linkUpdate = sdf.format(new Date());
    }

    public void setRadioStateText(String t) {
        this._radioState = t;
    }

    void setSelectBooleanState(String value) {
        this._radioState = "selectBoolean set, " + value;
    }

    void setSelectOneState(String value) {
        this._radioState = "selectOne set, item " + value;
    }

    public void setTextValue(String t) {
        this._textValue = t;
    }

    public void resetCheckBox() {
        this._checkBoxUpdateCount = 0;
        this._checkBoxState = null;
    }

    public void incrementCheckBoxUpdateCount() {
        ++this._checkBoxUpdateCount;
    }

    public void incrementPrevalidateEventCount() {
        ++this._prevalidateEventCount;
    }

    public String getUploadFileState() {
        return this._uploadFileState;
    }

    public void setUploadFile(UploadedFile file) {
        this._uploadFileState = file == null ? _DEFAULT_UPLOAD_FILE : String.format("Uploaded file %s (%d bytes)", file.getFilename(), file.getLength());
    }

    public void reset() {
        this.resetCheckBox();
        this._choiceInt = null;
        this._linkUpdate = _DEFAULT_LINK_UPDATE;
        this._radioState = _DEFAULT_RADIO_STATE;
        this._textValue = _DEFAULT_TEXT_VALUE;
        this._uploadFileState = _DEFAULT_UPLOAD_FILE;
        this._prevalidateEventCount = 0;
    }
}

