/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo.webapp;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RedirectFilter
implements Filter {
    public static final String URL_PATTERN_PARAM = "faces-servlet-url-pattern";
    public static final String DEFAULT_URL_PATTERN = "/faces/*";
    private String _servletPath;

    public void init(FilterConfig filterConfig) throws ServletException {
        int offset;
        String pattern = filterConfig.getInitParameter(URL_PATTERN_PARAM);
        if (pattern == null) {
            pattern = DEFAULT_URL_PATTERN;
        }
        if ((offset = pattern.indexOf(42)) > 1 && pattern.charAt(offset - 1) == '/') {
            --offset;
        }
        this._servletPath = pattern.substring(0, offset);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest;
        String servletPath;
        if (request instanceof HttpServletRequest && !(servletPath = (httpRequest = (HttpServletRequest)request).getServletPath()).startsWith(this._servletPath)) {
            servletPath = this._servletPath + servletPath;
            String pathInfo = httpRequest.getPathInfo();
            String queryString = httpRequest.getQueryString();
            String url = httpRequest.getContextPath() + servletPath + (pathInfo == null ? "" : pathInfo) + (queryString == null ? "" : queryString);
            ((HttpServletResponse)response).sendRedirect(url);
            return;
        }
        chain.doFilter(request, response);
    }
}

