/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.faces.component.UIComponent;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidaddemo.ComponentEditorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentEditorHandler {
    private UIComponent _editedComponent;
    private boolean _javascriptShown = true;
    private List<PropertyOfComponent> _list;

    public String update() {
        boolean rendered = this._editedComponent.isRendered();
        List list = this._list;
        if (list != null) {
            for (PropertyOfComponent prop : list) {
                prop.flushToComponent();
            }
        }
        RequestContext rc = RequestContext.getCurrentInstance();
        if (rendered != this._editedComponent.isRendered()) {
            rc.addPartialTarget(this._editedComponent.getParent());
        } else {
            rc.addPartialTarget(this._editedComponent);
        }
        return null;
    }

    public void setComponent(UIComponent component) {
        this._editedComponent = component;
    }

    public UIComponent getComponent() {
        return this._editedComponent;
    }

    public boolean isJavascriptShown() {
        return this._javascriptShown;
    }

    public void setJavascriptShown(boolean javascriptShown) {
        this._javascriptShown = javascriptShown;
    }

    public List<PropertyOfComponent> getAttributes() {
        if (this._list != null) {
            return this._list;
        }
        UIComponent comp = this.getComponent();
        if (comp == null) {
            return null;
        }
        ArrayList<PropertyOfComponent> list = new ArrayList<PropertyOfComponent>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(comp.getClass());
            PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                String name;
                boolean readOnly;
                PropertyDescriptor descriptor = descriptors[i];
                if (descriptor.getReadMethod() == null) continue;
                StringProperty poc = null;
                boolean bl = readOnly = descriptor.getWriteMethod() == null;
                if (readOnly || comp.getValueBinding(name = descriptor.getName()) != null) continue;
                Class<?> type = descriptor.getPropertyType();
                if (type == String.class || type == Object.class) {
                    if (!this.isJavascriptShown() && name.startsWith("on")) continue;
                    poc = new StringProperty(comp, descriptor);
                } else if (type == Integer.class || type == Integer.TYPE) {
                    poc = new IntegerProperty(comp, descriptor);
                } else if (type == Boolean.class || type == Boolean.TYPE) {
                    poc = new BooleanProperty(comp, descriptor);
                } else if (type == Date.class) {
                    poc = new DateProperty(comp, descriptor);
                }
                if (poc == null) continue;
                list.add((PropertyOfComponent)poc);
            }
            Collections.sort(list);
            this._list = list;
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

