/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidaddemo;

import java.io.Serializable;
import java.io.StringWriter;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.component.core.data.CoreChart;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.ChartDrillDownEvent;
import org.apache.myfaces.trinidad.model.ChartModel;
import org.apache.myfaces.trinidad.render.ExtendedRenderKitService;
import org.apache.myfaces.trinidad.util.Service;
import org.apache.myfaces.trinidaddemo.ChartBean;
import org.apache.myfaces.trinidaddemo.ComponentEditorHandler;

public class ChartBean
implements Serializable {
    private boolean _largerDataSet = false;
    private int _currentTypeIndex = 0;
    private static final String[] _chartTypes = new String[]{"verticalBar", "horizontalBar", "stackedVerticalBar", "stackedHorizontalBar", "pie", "area", "stackedArea", "line", "barLine", "XYLine", "scatterPlot", "radar", "radarArea", "funnel", "circularGauge", "semiCircularGauge"};
    private final ChartModel _chartModel = new MyChartModel(this, null);
    private final ComponentEditorHandler _editorBean = new ComponentEditorHandler();

    public ChartModel getValue() {
        return this._chartModel;
    }

    public ComponentEditorHandler getEditor() {
        return this._editorBean;
    }

    public String updatePartial() {
        this._editorBean.update();
        RequestContext afContext = RequestContext.getCurrentInstance();
        afContext.addPartialTarget(this._editorBean.getComponent());
        return null;
    }

    public String nextChartType() {
        ++this._currentTypeIndex;
        if (this._currentTypeIndex >= _chartTypes.length) {
            this._currentTypeIndex = 0;
        }
        CoreChart chart = (CoreChart)this._editorBean.getComponent();
        chart.setType(_chartTypes[this._currentTypeIndex]);
        return null;
    }

    public boolean isLargerDataSet() {
        return this._largerDataSet;
    }

    public void setLargerDataSet(boolean b) {
        this._largerDataSet = b;
        CoreChart chart = (CoreChart)this._editorBean.getComponent();
        if (this._largerDataSet) {
            chart.setXMajorGridLineCount(1);
        } else {
            chart.setXMajorGridLineCount(-1);
        }
    }

    public void drillDown(ChartDrillDownEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        String message = "seriesIndices : " + this._getEventIntsAsString(event.getSeriesIndices()) + " yValueIndices : " + this._getEventIntsAsString(event.getYValueIndices()) + " yValues :" + this._getEventDoublesAsString(event.getYValues()) + " xValues :" + this._getEventDoublesAsString(event.getXValues());
        ExtendedRenderKitService erks = (ExtendedRenderKitService)Service.getRenderKitService((FacesContext)context, ExtendedRenderKitService.class);
        erks.addScript(context, "alert('Confirmation from ChartBean: " + message + "');");
    }

    private String _getEventIntsAsString(int[] intArray) {
        if (intArray != null) {
            StringWriter sw = new StringWriter();
            for (int i = 0; i < intArray.length; ++i) {
                if (i != 0) {
                    sw.append(',');
                }
                sw.append(String.valueOf(intArray[i]));
            }
            return sw.toString();
        }
        return null;
    }

    private String _getEventDoublesAsString(double[] intArray) {
        if (intArray != null) {
            StringWriter sw = new StringWriter();
            for (int i = 0; i < intArray.length; ++i) {
                if (i != 0) {
                    sw.append(',');
                }
                sw.append(String.valueOf(intArray[i]));
            }
            return sw.toString();
        }
        return null;
    }

    static /* synthetic */ boolean access$000(ChartBean x0) {
        return x0._largerDataSet;
    }

    static /* synthetic */ ComponentEditorHandler access$100(ChartBean x0) {
        return x0._editorBean;
    }
}

