/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.model;

import java.io.Serializable;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.SortStrength;

public class SortCriterion
implements Serializable {
    private final String _property;
    private final boolean _sortOrder;
    private final SortStrength _sortStrength;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(SortCriterion.class);
    private static final long serialVersionUID = 1L;

    public SortCriterion(String property, boolean isAscending) {
        this(property, isAscending, SortStrength.IDENTICAL);
    }

    public SortCriterion(String property, boolean isAscending, SortStrength sortStrength) {
        if (property == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_PROPERTY"));
        }
        if (sortStrength == null) {
            throw new NullPointerException(_LOG.getMessage("NULL_SORT_STRENGTH"));
        }
        this._property = property;
        this._sortOrder = isAscending;
        this._sortStrength = sortStrength;
    }

    public boolean isAscending() {
        return this._sortOrder;
    }

    public String getProperty() {
        return this._property;
    }

    public SortStrength getSortStrength() {
        return this._sortStrength;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SortCriterion) {
            SortCriterion that = (SortCriterion)obj;
            return this.getProperty().equals(that.getProperty()) && this.isAscending() == that.isAscending() && this.getSortStrength() == that.getSortStrength();
        }
        return false;
    }

    public int hashCode() {
        int hc = this.getProperty().hashCode();
        hc = hc * 37 + this._sortStrength.hashCode();
        return this.isAscending() ? hc : -hc;
    }
}

