/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.examples.listexample;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.event.ActionEvent;
import org.apache.myfaces.component.html.ext.HtmlDataTable;
import org.apache.myfaces.examples.listexample.SimpleCity;
import org.apache.myfaces.examples.listexample.SimpleCountry;

public class SimpleCountryList {
    private List _countries = new ArrayList();

    SimpleCountry getSimpleCountry(long id) {
        for (int i = 0; i < this._countries.size(); ++i) {
            SimpleCountry country = (SimpleCountry)this._countries.get(i);
            if (country.getId() != id) continue;
            return country;
        }
        return null;
    }

    long getNewSimpleCountryId() {
        long maxId = 0L;
        for (int i = 0; i < this._countries.size(); ++i) {
            SimpleCountry country = (SimpleCountry)this._countries.get(i);
            if (country.getId() <= maxId) continue;
            maxId = country.getId();
        }
        return maxId + 1L;
    }

    void saveSimpleCountry(SimpleCountry simpleCountry) {
        if (simpleCountry.getId() == 0L) {
            simpleCountry.setId(this.getNewSimpleCountryId());
        }
        boolean found = false;
        for (int i = 0; i < this._countries.size(); ++i) {
            SimpleCountry country = (SimpleCountry)this._countries.get(i);
            if (country.getId() != simpleCountry.getId()) continue;
            this._countries.set(i, simpleCountry);
            found = true;
        }
        if (!found) {
            this._countries.add(simpleCountry);
        }
    }

    void deleteSimpleCountry(SimpleCountry simpleCountry) {
        for (int i = 0; i < this._countries.size(); ++i) {
            SimpleCountry country = (SimpleCountry)this._countries.get(i);
            if (country.getId() != simpleCountry.getId()) continue;
            this._countries.remove(i);
        }
    }

    public SimpleCountryList() {
        this._countries.add(new SimpleCountry(1L, "AUSTRIA", "AT", new BigDecimal(123L), this.createCities(new String[]{"Wien", "Graz", "Linz", "Salzburg"})));
        this._countries.add(new SimpleCountry(2L, "AZERBAIJAN", "AZ", new BigDecimal(535L), this.createCities(new String[]{"Baku", "Sumgait", "Qabala", "Agdam"})));
        this._countries.add(new SimpleCountry(3L, "BAHAMAS", "BS", new BigDecimal(1345623L), this.createCities(new String[]{"Nassau", "Alice Town", "Church Grove", "West End"})));
        this._countries.add(new SimpleCountry(4L, "BAHRAIN", "BH", new BigDecimal(346L), this.createCities(new String[]{"Bahrain"})));
        this._countries.add(new SimpleCountry(5L, "BANGLADESH", "BD", new BigDecimal(456L), this.createCities(new String[]{"Chittagong", "Chandpur", "Bogra", "Feni"})));
        this._countries.add(new SimpleCountry(6L, "BARBADOS", "BB", new BigDecimal(45645L), this.createCities(new String[]{"Grantley Adams"})));
    }

    private SimpleCity[] createCities(String[] names) {
        SimpleCity[] result = new SimpleCity[names.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new SimpleCity(names[i]);
        }
        return result;
    }

    public List getCountries() {
        return this._countries;
    }

    public Map getCountryMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        List li = this.getCountries();
        for (int i = 0; i < li.size(); ++i) {
            SimpleCountry simpleCountry = (SimpleCountry)li.get(i);
            map.put(simpleCountry.getIsoCode(), simpleCountry.getName());
        }
        return map;
    }

    public void setCountries(List countries) {
        this._countries = countries;
    }

    public String addCountry() {
        List list = this.getCountries();
        list.add(new SimpleCountry((long)(list.size() + 1), "", "", new BigDecimal(0), this.createCities(new String[0])));
        return "ok";
    }

    public void deleteCountry(ActionEvent ev) {
        HtmlDataTable datatable = this.findParentHtmlDataTable(ev.getComponent());
        this.getCountries().remove(datatable.getRowIndex() + datatable.getFirst());
    }

    private HtmlDataTable findParentHtmlDataTable(UIComponent component) {
        if (component == null) {
            return null;
        }
        if (component instanceof HtmlDataTable) {
            return (HtmlDataTable)component;
        }
        return this.findParentHtmlDataTable(component.getParent());
    }
}

