/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.examples.listexample;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import org.apache.myfaces.examples.listexample.ColumnHeader;
import org.apache.myfaces.examples.listexample.OpenDataList;
import org.apache.myfaces.examples.listexample.SortableList;

public class OpenDataList
extends SortableList {
    private DataModel data;
    private DataModel columnHeaders;
    private static final int SORT_ASCENDING = 1;
    private static final int SORT_DESCENDING = -1;

    public OpenDataList() {
        super(null);
        ArrayList<ColumnHeader> headerList = new ArrayList<ColumnHeader>();
        headerList.add(new ColumnHeader("Index", "100", false));
        headerList.add(new ColumnHeader("Type", "200", true));
        headerList.add(new ColumnHeader("Model", "300", true));
        this.columnHeaders = new ListDataModel(headerList);
        ArrayList rowList = new ArrayList();
        for (int i = 100; i <= 999; ++i) {
            ArrayList<Object> colList = new ArrayList<Object>();
            colList.add(new Integer(i));
            colList.add("Car Type " + i);
            colList.add(i % 2 == 0 ? "blue" : "green");
            rowList.add(colList);
        }
        this.data = new ListDataModel(rowList);
    }

    public DataModel getData() {
        this.sort(this.getSort(), this.isAscending());
        return this.data;
    }

    void setData(DataModel datamodel) {
        System.out.println("preserved datamodel updated");
    }

    public DataModel getColumnHeaders() {
        return this.columnHeaders;
    }

    public Object getColumnValue() {
        Object columnValue = null;
        if (this.data.isRowAvailable() && this.columnHeaders.isRowAvailable()) {
            columnValue = ((List)this.data.getRowData()).get(this.columnHeaders.getRowIndex());
        }
        return columnValue;
    }

    public void setColumnValue(Object value) {
        if (this.data.isRowAvailable() && this.columnHeaders.isRowAvailable()) {
            ((List)this.data.getRowData()).set(this.columnHeaders.getRowIndex(), value);
        }
    }

    public String getColumnWidth() {
        String columnWidth = null;
        if (this.data.isRowAvailable() && this.columnHeaders.isRowAvailable()) {
            columnWidth = ((ColumnHeader)this.columnHeaders.getRowData()).getWidth();
        }
        return columnWidth;
    }

    public boolean isValueModifiable() {
        boolean valueModifiable = false;
        if (this.data.isRowAvailable() && this.columnHeaders.isRowAvailable()) {
            valueModifiable = ((ColumnHeader)this.columnHeaders.getRowData()).isEditable();
        }
        return valueModifiable;
    }

    protected boolean isDefaultAscending(String sortColumn) {
        return true;
    }

    protected void sort(String column, boolean ascending) {
        if (column != null) {
            int columnIndex = this.getColumnIndex(column);
            int direction = ascending ? 1 : -1;
            this.sort(columnIndex, direction);
        }
    }

    protected void sort(int columnIndex, int direction) {
        1 comparator = new /* Unavailable Anonymous Inner Class!! */;
        Collections.sort((List)this.data.getWrappedData(), comparator);
    }

    private int getColumnIndex(String columnName) {
        int columnIndex = -1;
        List headers = (List)this.columnHeaders.getWrappedData();
        for (int i = 0; i < headers.size() && columnIndex == -1; ++i) {
            ColumnHeader header = (ColumnHeader)headers.get(i);
            if (!header.getLabel().equals(columnName)) continue;
            columnIndex = i;
        }
        return columnIndex;
    }
}

