/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.myfaces.tobago.maven.plugin.AbstractThemeMojo;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.FileUtils;

public class PackThemeMojo
extends AbstractThemeMojo {
    private MavenProjectHelper projectHelper;
    private String outputDirectory;
    private String jarName;
    private File webappDirectory;
    private ZipArchiver archiver;
    private File warSourceDirectory;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    public static final String WEB_INF = "WEB-INF";

    public File getWarSourceDirectory() {
        return this.warSourceDirectory;
    }

    public File getWebappDirectory() {
        return this.webappDirectory;
    }

    public void execute() throws MojoExecutionException {
        File jarFile = new File(this.outputDirectory, this.jarName + "-THEME.jar");
        try {
            this.performPackaging(jarFile);
            this.projectHelper.attachArtifact(this.getProject(), "jar", "THEME", jarFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling theme", e);
        }
    }

    private void performPackaging(File jarFile) throws IOException, ArchiverException, MojoExecutionException {
        this.buildExplodedTheme(this.getWebappDirectory());
        this.getLog().info((CharSequence)("Generating theme " + jarFile.getAbsolutePath()));
        this.archiver.addDirectory(this.getWebappDirectory(), this.getIncludes(), this.getExcludes());
        this.archiver.setDestFile(jarFile);
        this.archiver.createArchive();
    }

    public void buildExplodedTheme(File zipDirectory) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Exploding theme...");
        zipDirectory.mkdirs();
        try {
            this.copyResources(this.getWarSourceDirectory(), zipDirectory);
            this.buildTheme(this.getProject(), this.getWebappDirectory());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not explode theme...", (Exception)e);
        }
    }

    public void copyResources(File sourceDirectory, File webappDirectory) throws IOException {
        if (!sourceDirectory.equals(webappDirectory)) {
            this.getLog().info((CharSequence)("Copy theme resources to " + webappDirectory.getAbsolutePath()));
            if (this.getWarSourceDirectory().exists()) {
                String[] fileNames = this.getThemeFiles(sourceDirectory);
                for (int i = 0; i < fileNames.length; ++i) {
                    FileUtils.copyFile((File)new File(sourceDirectory, fileNames[i]), (File)new File(webappDirectory, "tobago/" + fileNames[i]));
                }
            }
        }
    }

    public void buildTheme(MavenProject project, File webappDirectory) throws IOException {
        this.getLog().info((CharSequence)("Assembling theme " + project.getArtifactId() + " in " + webappDirectory));
        File libDirectory = new File(webappDirectory, "WEB-INF/lib");
        libDirectory.mkdirs();
        Artifact artifact = project.getArtifact();
        this.getLog().debug((CharSequence)artifact.toString());
        FileUtils.copyFile((File)artifact.getFile(), (File)new File(libDirectory, artifact.getFile().getName()));
    }

    protected String[] getExcludes() {
        ArrayList excludeList = new ArrayList(FileUtils.getDefaultExcludesAsList());
        return excludeList.toArray(new String[0]);
    }

    protected String[] getIncludes() {
        return new String[]{"**"};
    }
}

