/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.buildtools.maven2.plugin.jdeveloper;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.myfaces.buildtools.maven2.plugin.jdeveloper.TldContentHandler;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.xml.sax.SAXException;

public class JDeveloperMojo
extends AbstractMojo {
    private String[] libraries;
    private File[] sourceRoots;
    private File[] testSourceRoots;
    private File[] resourceRoots;
    private File[] testResourceRoots;
    private boolean force;
    private String compiler;
    private boolean makeProject;
    private String runTarget;
    private String release;
    private MavenProject project;
    private List reactorProjects;
    private String tagLibDirectory;
    private Properties[] distributedTagLibraries;
    private int _releaseMajor = 0;
    private boolean _addLibraries = true;
    private boolean _addTagLibs = true;
    private static final String _PROPERTY_ADD_LIBRARY = "jdev.plugin.add.libraries";
    private static final String _PROPERTY_ADD_TAGLIBS = "jdev.plugin.add.taglibs";

    public void execute() throws MojoExecutionException {
        this._parseRelease();
        try {
            this.generateWorkspace();
            this.generateProject();
            this.generateTestProject();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void generateWorkspace() throws MojoExecutionException, IOException {
        if (!this.project.getCollectedProjects().isEmpty()) {
            this.getLog().info((CharSequence)("Generating JDeveloper " + this.release + " workspace: " + this.project.getArtifactId()));
            File workspaceFile = this.getJWorkspaceFile(this.project);
            try {
                Xpp3Dom workspaceDOM = this.readWorkspaceDOM(workspaceFile);
                this.replaceProjects(workspaceFile.getParentFile(), workspaceDOM);
                this.writeDOM(workspaceFile, workspaceDOM);
            }
            catch (XmlPullParserException e) {
                throw new MojoExecutionException("Error generating workspace", (Exception)((Object)e));
            }
        }
    }

    private void generateProject() throws IOException, MojoExecutionException {
        if (!"pom".equals(this.project.getPackaging())) {
            File projectFile = this.getJProjectFile(this.project);
            Properties props = this.project.getProperties();
            String addLibs = (String)props.get(_PROPERTY_ADD_LIBRARY);
            String addTagLibs = (String)props.get(_PROPERTY_ADD_TAGLIBS);
            this._addLibraries = addLibs == null ? true : new Boolean(addLibs);
            this._addTagLibs = addTagLibs == null ? true : new Boolean(addTagLibs);
            File webappDir = new File(this.project.getBasedir(), "src/main/webapp");
            File outputDir = new File(this.project.getBuild().getDirectory(), "classes");
            MavenProject executionProject = this.project.getExecutionProject();
            List compileSourceRoots = executionProject.getCompileSourceRoots();
            if (this.sourceRoots != null) {
                for (int i = 0; i < this.sourceRoots.length; ++i) {
                    compileSourceRoots.add(this.sourceRoots[i].getAbsolutePath());
                }
            }
            List compileResourceRoots = executionProject.getResources();
            if (this.resourceRoots != null) {
                for (int i = 0; i < this.resourceRoots.length; ++i) {
                    Resource resource = new Resource();
                    resource.setDirectory(this.resourceRoots[i].getAbsolutePath());
                    compileResourceRoots.add(resource);
                }
            }
            this.getLog().info((CharSequence)("Generating JDeveloper " + this.release + " Project " + this.project.getArtifactId()));
            LinkedHashSet pluginArtifacts = new LinkedHashSet();
            pluginArtifacts.addAll(this.project.getPluginArtifacts());
            LinkedHashSet compileArtifacts = new LinkedHashSet();
            compileArtifacts.addAll(this.project.getCompileArtifacts());
            compileArtifacts.addAll(this.project.getRuntimeArtifacts());
            this.generateProject(projectFile, this.project.getArtifactId(), this.project.getPackaging(), this.project.getDependencies(), new ArrayList(compileArtifacts), compileSourceRoots, compileResourceRoots, Collections.singletonList(webappDir.getPath()), outputDir);
        }
    }

    private void generateTestProject() throws IOException, MojoExecutionException {
        if (!"pom".equals(this.project.getPackaging())) {
            File projectFile = this.getJProjectTestFile(this.project);
            Properties props = this.project.getProperties();
            String addLibs = (String)props.get(_PROPERTY_ADD_LIBRARY);
            String addTagLibs = (String)props.get(_PROPERTY_ADD_TAGLIBS);
            this._addLibraries = addLibs == null ? true : new Boolean(addLibs);
            this._addTagLibs = addTagLibs == null ? true : new Boolean(addTagLibs);
            File webappDir = new File(this.project.getBasedir(), "src/test/webapp");
            File outputDir = new File(this.project.getBuild().getDirectory(), "test-classes");
            ArrayList<Dependency> testDependencies = new ArrayList<Dependency>(this.project.getTestDependencies());
            Dependency selfDependency = new Dependency();
            selfDependency.setArtifactId(this.project.getArtifactId());
            selfDependency.setGroupId(this.project.getGroupId());
            selfDependency.setType(this.project.getPackaging());
            testDependencies.add(selfDependency);
            MavenProject executionProject = this.project.getExecutionProject();
            List compileSourceRoots = executionProject.getTestCompileSourceRoots();
            if (this.testSourceRoots != null) {
                for (int i = 0; i < this.testSourceRoots.length; ++i) {
                    compileSourceRoots.add(this.testSourceRoots[i].getAbsolutePath());
                }
            }
            List compileResourceRoots = executionProject.getTestResources();
            if (this.testResourceRoots != null) {
                for (int i = 0; i < this.testResourceRoots.length; ++i) {
                    Resource resource = new Resource();
                    resource.setDirectory(this.testSourceRoots[i].getAbsolutePath());
                    compileResourceRoots.add(resource);
                }
            }
            this.getLog().info((CharSequence)("Generating JDeveloper " + this.release + " Project " + this.project.getArtifactId() + "-test"));
            this.generateProject(projectFile, this.project.getArtifactId() + "-test", this.project.getPackaging(), testDependencies, this.project.getTestArtifacts(), compileSourceRoots, compileResourceRoots, Collections.singletonList(webappDir.getPath()), outputDir);
        }
    }

    private void generateProject(File projectFile, String projectName, String packaging, List dependencies, List artifacts, List sourceRoots, List resourceRoots, List webSourceRoots, File outputDir) throws IOException, MojoExecutionException {
        try {
            File projectDir = projectFile.getParentFile();
            Xpp3Dom projectDOM = this.readProjectDOM(projectFile);
            this.replaceWebappInfo(projectName, projectDOM);
            this.replaceSourcePaths(projectDir, sourceRoots, resourceRoots, projectDOM);
            this.replaceWebSourcePaths(projectDir, webSourceRoots, projectDOM);
            this.replaceDependencies(projectDir, dependencies, projectDOM);
            this.replaceLibraries(projectDir, artifacts, projectDOM);
            this.replaceTagLibraries(projectDOM);
            this.replaceOutputDirectory(projectDir, outputDir, projectDOM);
            this.replaceParameters(projectName, projectDOM);
            this.writeDOM(projectFile, projectDOM);
            if ("war".equals(packaging)) {
                this.copyTagLibraries(projectDir, dependencies, artifacts);
            }
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error generating project", (Exception)((Object)e));
        }
    }

    private void replaceProjects(File workspaceDir, Xpp3Dom workspaceDOM) throws XmlPullParserException {
        Xpp3Dom sourceDOM = workspaceDOM.getChild("list");
        Xpp3Dom targetDOM = new Xpp3Dom("list");
        Iterator i = this.project.getCollectedProjects().iterator();
        while (i.hasNext()) {
            MavenProject collectedProject = (MavenProject)i.next();
            if ("pom".equals(collectedProject.getPackaging())) continue;
            File projectFile = this.getJProjectFile(collectedProject);
            targetDOM.addChild(this.createProjectReferenceDOM(workspaceDir, projectFile));
            File testProjectFile = this.getJProjectTestFile(collectedProject);
            targetDOM.addChild(this.createProjectReferenceDOM(workspaceDir, testProjectFile));
        }
        this.removeChildren(sourceDOM);
        Xpp3Dom.mergeXpp3Dom((Xpp3Dom)sourceDOM, (Xpp3Dom)targetDOM, (Boolean)Boolean.FALSE);
    }

    private void replaceWebSourcePaths(File projectDir, List sourceRoots, Xpp3Dom projectDOM) throws XmlPullParserException {
        Xpp3Dom pathsDOM = this.findNamedChild(projectDOM, "hash", "oracle.jdeveloper.model.J2eeSettings");
        Xpp3Dom contentSetDOM = this.findNamedChild(pathsDOM, "hash", "webContentSet");
        Xpp3Dom sourceDOM = this.findNamedChild(contentSetDOM, "list", "url-path");
        Xpp3Dom targetDOM = new Xpp3Dom("list");
        Iterator i = sourceRoots.iterator();
        while (i.hasNext()) {
            File sourceRoot = new File((String)i.next());
            String relativeRoot = this.getRelativeDir(projectDir, sourceRoot);
            Xpp3Dom urlDOM = new Xpp3Dom("url");
            urlDOM.setAttribute("path", relativeRoot);
            targetDOM.addChild(urlDOM);
        }
        this.removeChildren(sourceDOM);
        Xpp3Dom.mergeXpp3Dom((Xpp3Dom)sourceDOM, (Xpp3Dom)targetDOM, (Boolean)Boolean.FALSE);
    }

    private void replaceWebappInfo(String projectName, Xpp3Dom projectDOM) throws XmlPullParserException {
        Xpp3Dom settingsDOM = this.findNamedChild(projectDOM, "hash", "oracle.jdeveloper.model.J2eeSettings");
        Xpp3Dom webappNameDOM = this.findNamedChild(settingsDOM, "value", "j2eeWebAppName");
        Xpp3Dom webappContextDOM = this.findNamedChild(settingsDOM, "value", "j2eeWebContextRoot");
        webappNameDOM.setAttribute("v", projectName + "-webapp");
        webappContextDOM.setAttribute("v", projectName + "-context-root");
    }

    private void replaceSourcePaths(File projectDir, List sourceRoots, List resourceRoots, Xpp3Dom projectDOM) throws XmlPullParserException {
        Xpp3Dom pathsDOM = this.findNamedChild(projectDOM, "hash", "oracle.jdeveloper.model.PathsConfiguration");
        Xpp3Dom contentSetDOM = this.findNamedChild(pathsDOM, "hash", "javaContentSet");
        Xpp3Dom sourceDOM = this.findNamedChild(contentSetDOM, "list", "constituent-sets");
        Xpp3Dom targetDOM = new Xpp3Dom("list");
        Collections.sort(sourceRoots);
        Iterator i = sourceRoots.iterator();
        while (i.hasNext()) {
            File sourceRoot = new File((String)i.next());
            Xpp3Dom hashDOM = new Xpp3Dom("hash");
            Xpp3Dom listDOM = new Xpp3Dom("list");
            listDOM.setAttribute("n", "pattern-filters");
            hashDOM.addChild(listDOM);
            Xpp3Dom stringDOM = new Xpp3Dom("string");
            stringDOM.setAttribute("v", "+**");
            listDOM.addChild(stringDOM);
            listDOM = new Xpp3Dom("list");
            listDOM.setAttribute("n", "url-path");
            hashDOM.addChild(listDOM);
            String relativeRoot = this.getRelativeDir(projectDir, sourceRoot);
            Xpp3Dom urlDOM = new Xpp3Dom("url");
            urlDOM.setAttribute("path", relativeRoot);
            listDOM.addChild(urlDOM);
            targetDOM.addChild(hashDOM);
        }
        Collections.sort(resourceRoots, new Comparator(){

            public int compare(Object a, Object b) {
                Resource ra = (Resource)a;
                Resource rb = (Resource)b;
                return ra.getDirectory().compareTo(rb.getDirectory());
            }
        });
        i = resourceRoots.iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            File resourceRoot = new File(resource.getDirectory());
            String relativeRoot = this.getRelativeDir(projectDir, resourceRoot);
            Xpp3Dom hashDOM = new Xpp3Dom("hash");
            Xpp3Dom listDOM = new Xpp3Dom("list");
            listDOM.setAttribute("n", "pattern-filters");
            hashDOM.addChild(listDOM);
            Xpp3Dom stringDOM = null;
            if (relativeRoot.startsWith("src/test/resources")) {
                stringDOM = new Xpp3Dom("string");
                stringDOM.setAttribute("v", "-oracle/adfinternal/view/faces/renderkit/golden/");
                listDOM.addChild(stringDOM);
            }
            stringDOM = new Xpp3Dom("string");
            stringDOM.setAttribute("v", "+**");
            listDOM.addChild(stringDOM);
            listDOM = new Xpp3Dom("list");
            listDOM.setAttribute("n", "url-path");
            hashDOM.addChild(listDOM);
            Xpp3Dom urlDOM = new Xpp3Dom("url");
            urlDOM.setAttribute("path", relativeRoot);
            listDOM.addChild(urlDOM);
            targetDOM.addChild(hashDOM);
        }
        this.removeChildren(sourceDOM);
        Xpp3Dom.mergeXpp3Dom((Xpp3Dom)sourceDOM, (Xpp3Dom)targetDOM, (Boolean)Boolean.FALSE);
    }

    private void replaceResourcePaths(File projectDir, List resourceRoots, Xpp3Dom projectDOM) throws XmlPullParserException {
        Xpp3Dom pathsDOM = this.findNamedChild(projectDOM, "hash", "oracle.ide.model.ResourcePaths");
        Xpp3Dom contentSetDOM = this.findNamedChild(pathsDOM, "hash", "resourcesContentSet");
        Xpp3Dom sourceDOM = this.findNamedChild(contentSetDOM, "list", "url-path");
        Xpp3Dom targetDOM = new Xpp3Dom("list");
        Iterator i = resourceRoots.iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            File resourceRoot = new File(resource.getDirectory());
            String relativeRoot = this.getRelativeDir(projectDir, resourceRoot);
            Xpp3Dom urlDOM = new Xpp3Dom("url");
            urlDOM.setAttribute("path", relativeRoot);
            targetDOM.addChild(urlDOM);
        }
        this.removeChildren(sourceDOM);
        Xpp3Dom.mergeXpp3Dom((Xpp3Dom)sourceDOM, (Xpp3Dom)targetDOM, (Boolean)Boolean.FALSE);
    }

    private void replaceDependencies(File projectDir, List dependencies, Xpp3Dom projectDOM) throws XmlPullParserException {
        Xpp3Dom configDOM = this.findNamedChild(projectDOM, "hash", "oracle.ide.model.DependencyConfiguration");
        Xpp3Dom sourceDOM = this.findNamedChild(configDOM, "list", "dependencyList");
        Xpp3Dom targetDOM = new Xpp3Dom("list");
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            MavenProject dependentProject = this.findDependentProject(dependency.getManagementKey());
            if (dependentProject == null) continue;
            File dependentProjectFile = this.getJProjectFile(dependentProject);
            String relativePath = this.getRelativeFile(projectDir, dependentProjectFile);
            Xpp3Dom hashDOM = new Xpp3Dom("hash");
            Xpp3Dom valueDOM = new Xpp3Dom("value");
            valueDOM.setAttribute("n", "class");
            valueDOM.setAttribute("v", "oracle.jdeveloper.library.ProjectLibrary");
            Xpp3Dom srcOwnValDOM = new Xpp3Dom("value");
            srcOwnValDOM.setAttribute("n", "sourceOwnerURL");
            Xpp3Dom urlDOM = new Xpp3Dom("url");
            urlDOM.setAttribute("n", "sourceURL");
            urlDOM.setAttribute("path", relativePath);
            hashDOM.addChild(valueDOM);
            hashDOM.addChild(srcOwnValDOM);
            hashDOM.addChild(urlDOM);
            targetDOM.addChild(hashDOM);
        }
        this.removeChildren(sourceDOM);
        Xpp3Dom.mergeXpp3Dom((Xpp3Dom)sourceDOM, (Xpp3Dom)targetDOM, (Boolean)Boolean.FALSE);
    }

    private void replaceLibraries(File projectDir, List artifacts, Xpp3Dom projectDOM) throws XmlPullParserException {
        Xpp3Dom projectLibsDOM = this.findNamedChild(projectDOM, "hash", "oracle.jdevimpl.config.JProjectLibraries");
        Xpp3Dom internalDefsDOM = this.findNamedChild(projectLibsDOM, "hash", "internalDefinitions");
        Xpp3Dom sourceDefsDOM = this.findNamedChild(internalDefsDOM, "list", "libraryDefinitions");
        Xpp3Dom sourceRefsDOM = this.findNamedChild(projectLibsDOM, "list", "libraryReferences");
        Xpp3Dom targetDefsDOM = new Xpp3Dom("list");
        Xpp3Dom targetRefsDOM = new Xpp3Dom("list");
        Collections.sort(artifacts, new Comparator(){

            public int compare(Object a, Object b) {
                Artifact arta = (Artifact)a;
                Artifact artb = (Artifact)b;
                return arta.getId().compareTo(artb.getId());
            }
        });
        LinkedList<String> libraryRefs = new LinkedList<String>();
        Iterator i = artifacts.iterator();
        while (i.hasNext()) {
            Artifact artifact = (Artifact)i.next();
            if (this.isDependentProject(artifact.getDependencyConflictId())) continue;
            String id = artifact.getId();
            String path = this.getRelativeFile(projectDir, artifact.getFile());
            Xpp3Dom hashDOM = new Xpp3Dom("hash");
            Xpp3Dom listDOM = new Xpp3Dom("list");
            listDOM.setAttribute("n", "classPath");
            Xpp3Dom urlDOM = new Xpp3Dom("url");
            urlDOM.setAttribute("path", path);
            urlDOM.setAttribute("jar-entry", "");
            listDOM.addChild(urlDOM);
            hashDOM.addChild(listDOM);
            Xpp3Dom valueDOM = new Xpp3Dom("value");
            valueDOM.setAttribute("n", "deployedByDefault");
            valueDOM.setAttribute("v", "true");
            hashDOM.addChild(valueDOM);
            valueDOM = new Xpp3Dom("value");
            valueDOM.setAttribute("n", "description");
            valueDOM.setAttribute("v", id);
            hashDOM.addChild(valueDOM);
            valueDOM = new Xpp3Dom("value");
            valueDOM.setAttribute("n", "id");
            valueDOM.setAttribute("v", id);
            hashDOM.addChild(valueDOM);
            targetDefsDOM.addChild(hashDOM);
            libraryRefs.add(id);
        }
        if (this._addLibraries) {
            if (this._releaseMajor >= 11) {
                libraryRefs.add(0, "JSF 1.2");
                libraryRefs.add(0, "JSP Runtime");
            }
            if (this.libraries != null) {
                for (int i2 = 0; i2 < this.libraries.length; ++i2) {
                    if (this._releaseMajor >= 11 && ("JSF 1.2".equalsIgnoreCase(this.libraries[i2]) || "JSP Runtime".equalsIgnoreCase(this.libraries[i2]))) continue;
                    libraryRefs.add(0, this.libraries[i2]);
                }
            }
        }
        Collections.sort(libraryRefs);
        i = libraryRefs.iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            Xpp3Dom hashDOM = new Xpp3Dom("hash");
            Xpp3Dom valueDOM = new Xpp3Dom("value");
            valueDOM.setAttribute("n", "id");
            valueDOM.setAttribute("v", id);
            hashDOM.addChild(valueDOM);
            valueDOM = new Xpp3Dom("value");
            valueDOM.setAttribute("n", "isJDK");
            valueDOM.setAttribute("v", "false");
            hashDOM.addChild(valueDOM);
            targetRefsDOM.addChild(hashDOM);
        }
        this.removeChildren(sourceDefsDOM);
        this.removeChildren(sourceRefsDOM);
        Xpp3Dom.mergeXpp3Dom((Xpp3Dom)sourceDefsDOM, (Xpp3Dom)targetDefsDOM, (Boolean)Boolean.FALSE);
        Xpp3Dom.mergeXpp3Dom((Xpp3Dom)sourceRefsDOM, (Xpp3Dom)targetRefsDOM, (Boolean)Boolean.FALSE);
    }

    private void replaceLocalTagLibraries(Xpp3Dom targetLibsDOM) throws XmlPullParserException {
        TldContentHandler tldHandler = new TldContentHandler();
        String path = null;
        try {
            File webInfDir = new File(this.project.getBasedir(), "src/main/webapp/WEB-INF");
            if (webInfDir == null) {
                return;
            }
            File[] files = webInfDir.listFiles();
            if (files == null) {
                return;
            }
            Xpp3Dom hashDOM = null;
            Xpp3Dom valueDOM = null;
            for (int i = 0; i < files.length; ++i) {
                path = files[i].getPath();
                if (!path.endsWith(".tld")) continue;
                hashDOM = new Xpp3Dom("hash");
                tldHandler.parseTld(files[i]);
                valueDOM = new Xpp3Dom("value");
                valueDOM.setAttribute("n", "jspVersion");
                valueDOM.setAttribute("v", tldHandler.getJspVersion());
                hashDOM.addChild(valueDOM);
                valueDOM = new Xpp3Dom("value");
                valueDOM.setAttribute("n", "name");
                valueDOM.setAttribute("v", tldHandler.getName());
                hashDOM.addChild(valueDOM);
                valueDOM = new Xpp3Dom("value");
                valueDOM.setAttribute("n", "prefix");
                valueDOM.setAttribute("v", tldHandler.getPrefix());
                hashDOM.addChild(valueDOM);
                valueDOM = new Xpp3Dom("value");
                valueDOM.setAttribute("n", "tldURL");
                valueDOM.setAttribute("v", "WEB-INF/" + path.substring(path.indexOf("WEB-INF") + 8));
                hashDOM.addChild(valueDOM);
                valueDOM = new Xpp3Dom("value");
                valueDOM.setAttribute("n", "URI");
                valueDOM.setAttribute("v", tldHandler.getURI());
                hashDOM.addChild(valueDOM);
                valueDOM = new Xpp3Dom("value");
                valueDOM.setAttribute("n", "version");
                valueDOM.setAttribute("v", tldHandler.getVersion());
                hashDOM.addChild(valueDOM);
                targetLibsDOM.addChild(hashDOM);
            }
            return;
        }
        catch (SAXException saxex) {
            this.getLog().info((CharSequence)("SAX Parse Exception parsing " + path + ": " + saxex.getMessage()), (Throwable)saxex);
        }
        catch (IOException ioe) {
            this.getLog().info((CharSequence)("Unable to open an InputStream to " + path), (Throwable)ioe);
        }
        catch (ParserConfigurationException pce) {
            this.getLog().info((CharSequence)("Unable to create SAX parser for " + path), (Throwable)pce);
        }
    }

    private void replaceTagLibraries(Xpp3Dom projectDOM) throws XmlPullParserException {
        if (!this._addTagLibs) {
            return;
        }
        Xpp3Dom projectTagsDOM = this.findNamedChild(projectDOM, "hash", "oracle.jdevimpl.webapp.jsp.libraries.model.ProjectTagLibraries");
        Xpp3Dom tagLibsDOM = this.findNamedChild(projectTagsDOM, "list", "tag-libraries");
        Xpp3Dom targetLibsDOM = new Xpp3Dom("list");
        Xpp3Dom hashDOM = null;
        Xpp3Dom valueDOM = null;
        if (this.distributedTagLibraries != null && this.distributedTagLibraries.length > 0) {
            for (int i = 0; i < this.distributedTagLibraries.length; ++i) {
                Properties disTagLib = this.distributedTagLibraries[i];
                String nameName = null;
                String nameValue = null;
                String versionName = null;
                String versionValue = null;
                hashDOM = new Xpp3Dom("hash");
                Xpp3Dom hashBaseDOM = new Xpp3Dom("hash");
                hashBaseDOM.setAttribute("n", "baseLibrary");
                hashDOM.addChild(hashBaseDOM);
                Enumeration<?> keys = disTagLib.propertyNames();
                while (keys.hasMoreElements()) {
                    String name = (String)keys.nextElement();
                    String value = (String)disTagLib.get(name);
                    if ("name".equals(name)) {
                        nameName = name;
                        nameValue = value;
                        valueDOM = new Xpp3Dom("value");
                        valueDOM.setAttribute("n", name);
                        valueDOM.setAttribute("v", value);
                        hashBaseDOM.addChild(valueDOM);
                        valueDOM = new Xpp3Dom("value");
                        valueDOM.setAttribute("n", nameName);
                        valueDOM.setAttribute("v", nameValue);
                        hashDOM.addChild(valueDOM);
                        continue;
                    }
                    if ("version".equals(name)) {
                        versionName = name;
                        versionValue = value;
                        valueDOM = new Xpp3Dom("value");
                        valueDOM.setAttribute("n", name);
                        valueDOM.setAttribute("v", value);
                        hashBaseDOM.addChild(valueDOM);
                        valueDOM = new Xpp3Dom("value");
                        valueDOM.setAttribute("n", versionName);
                        valueDOM.setAttribute("v", versionValue);
                        hashDOM.addChild(valueDOM);
                        continue;
                    }
                    if ("tld".equals(name)) {
                        name = name + "URL";
                        value = this.tagLibDirectory + "/" + value;
                    }
                    valueDOM = new Xpp3Dom("value");
                    valueDOM.setAttribute("n", name);
                    valueDOM.setAttribute("v", value);
                    hashDOM.addChild(valueDOM);
                }
                if (hashDOM == null) continue;
                targetLibsDOM.addChild(hashDOM);
            }
        } else {
            this.replaceDefaultTagLibraries(projectDOM, targetLibsDOM);
        }
        this.replaceLocalTagLibraries(targetLibsDOM);
        this.removeChildren(tagLibsDOM);
        Xpp3Dom.mergeXpp3Dom((Xpp3Dom)tagLibsDOM, (Xpp3Dom)targetLibsDOM, (Boolean)Boolean.FALSE);
    }

    private void replaceDefaultTagLibraries(Xpp3Dom projectDOM, Xpp3Dom targetLibsDOM) throws XmlPullParserException {
        Xpp3Dom hashDOM = new Xpp3Dom("hash");
        Xpp3Dom hashBaseDOM = new Xpp3Dom("hash");
        Xpp3Dom valueDOM = null;
        hashBaseDOM.setAttribute("n", "baseLibrary");
        hashDOM.addChild(hashBaseDOM);
        valueDOM = new Xpp3Dom("value");
        valueDOM.setAttribute("n", "name");
        valueDOM.setAttribute("v", "JSF HTML");
        hashBaseDOM.addChild(valueDOM);
        valueDOM = new Xpp3Dom("value");
        valueDOM.setAttribute("n", "name");
        valueDOM.setAttribute("v", "JSF HTML");
        hashDOM.addChild(valueDOM);
        valueDOM = new Xpp3Dom("value");
        valueDOM.setAttribute("n", "version");
        valueDOM.setAttribute("v", "1.2");
        hashBaseDOM.addChild(valueDOM);
        valueDOM = new Xpp3Dom("value");
        valueDOM.setAttribute("n", "version");
        valueDOM.setAttribute("v", "1.2");
        hashDOM.addChild(valueDOM);
        valueDOM = new Xpp3Dom("value");
        valueDOM.setAttribute("n", "jspVersion");
        valueDOM.setAttribute("v", "2.1");
        hashDOM.addChild(valueDOM);
        valueDOM = new Xpp3Dom("value");
        valueDOM.setAttribute("n", "tldURL");
        valueDOM.setAttribute("v", this.tagLibDirectory + "/html_basic.tld");
        hashDOM.addChild(valueDOM);
        valueDOM = new Xpp3Dom("value");
        valueDOM.setAttribute("n", "URI");
        valueDOM.setAttribute("v", "http://java.sun.com/jsf/html");
        hashDOM.addChild(valueDOM);
        if (hashDOM != null) {
            targetLibsDOM.addChild(hashDOM);
        }
        hashDOM = new Xpp3Dom("hash");
        hashBaseDOM = new Xpp3Dom("hash");
        hashBaseDOM.setAttribute("n", "baseLibrary");
        hashDOM.addChild(hashBaseDOM);
        valueDOM = new Xpp3Dom("value");
        valueDOM.setAttribute("n", "name");
        valueDOM.setAttribute("v", "JSF Core");
        hashBaseDOM.addChild(valueDOM);
        valueDOM = new Xpp3Dom("value");
        valueDOM.setAttribute("n", "name");
        valueDOM.setAttribute("v", "JSF Core");
        hashDOM.addChild(valueDOM);
        valueDOM = new Xpp3Dom("value");
        valueDOM.setAttribute("n", "version");
        valueDOM.setAttribute("v", "1.2");
        hashBaseDOM.addChild(valueDOM);
        valueDOM = new Xpp3Dom("value");
        valueDOM.setAttribute("n", "version");
        valueDOM.setAttribute("v", "1.2");
        hashDOM.addChild(valueDOM);
        valueDOM = new Xpp3Dom("value");
        valueDOM.setAttribute("n", "jspVersion");
        valueDOM.setAttribute("v", "2.1");
        hashDOM.addChild(valueDOM);
        valueDOM = new Xpp3Dom("value");
        valueDOM.setAttribute("n", "tldURL");
        valueDOM.setAttribute("v", this.tagLibDirectory + "/jsf_core.tld");
        hashDOM.addChild(valueDOM);
        valueDOM = new Xpp3Dom("value");
        valueDOM.setAttribute("n", "URI");
        valueDOM.setAttribute("v", "http://java.sun.com/jsf/core");
        hashDOM.addChild(valueDOM);
        if (hashDOM != null) {
            targetLibsDOM.addChild(hashDOM);
        }
    }

    private void replaceParameters(String projectName, Xpp3Dom projectDOM) throws XmlPullParserException {
        if (this._releaseMajor >= 11 && projectName != null) {
            this.replaceCompiler(projectDOM);
            this.replaceMakeProjectAndRunTarget(projectDOM);
        }
    }

    private void replaceCompiler(Xpp3Dom projectDOM) throws XmlPullParserException {
        Xpp3Dom configDOM = this.findNamedChild(projectDOM, "hash", "oracle.jdeveloper.compiler.OjcConfiguration");
        Xpp3Dom compilerDOM = this.findNamedChild(configDOM, "value", "compiler.name");
        String compilerValue = "Ojc";
        if (this.compiler != null && "Javac".equalsIgnoreCase(this.compiler)) {
            compilerValue = "Javac";
        }
        compilerDOM.setAttribute("v", compilerValue);
    }

    private void replaceMakeProjectAndRunTarget(Xpp3Dom projectDOM) throws XmlPullParserException {
        Xpp3Dom configDOM = this.findNamedChild(projectDOM, "hash", "oracle.jdeveloper.runner.RunConfigurations");
        Xpp3Dom defsDOM = this.findNamedChild(configDOM, "hash", "runConfigurationDefinitions");
        Xpp3Dom defaultDOM = this.findNamedChild(defsDOM, "hash", "Default");
        Xpp3Dom makeProjectDom = this.findNamedChild(defaultDOM, "value", "compileBeforeRun");
        if (this.makeProject) {
            makeProjectDom.setAttribute("v", "true");
        } else {
            makeProjectDom.setAttribute("v", "false");
        }
        if (this.runTarget != null && !"".equals(this.runTarget)) {
            String targetURL = "";
            targetURL = File.separatorChar == '/' ? this.runTarget.replace('\\', '/') : this.runTarget.replace('/', '\\');
            Xpp3Dom targetDOM = new Xpp3Dom("url");
            targetDOM.setAttribute("path", targetURL);
            targetDOM.setAttribute("n", "targetURL");
            defaultDOM.addChild(targetDOM);
        }
    }

    private void copyTagLibraries(File projectDir, List dependencies, List artifacts) throws IOException {
        File targetDir = new File(projectDir, "src/main/webapp/WEB-INF");
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            MavenProject dependentProject = this.findDependentProject(dependency.getManagementKey());
            if (dependentProject == null) continue;
            List resourceRoots = dependentProject.getResources();
            Iterator j = resourceRoots.iterator();
            while (j.hasNext()) {
                Resource resource = (Resource)j.next();
                String resourceRoot = resource.getDirectory();
                File resourceDirectory = new File(resourceRoot);
                if (!resourceDirectory.exists()) continue;
                DirectoryScanner scanner = new DirectoryScanner();
                scanner.setBasedir(resourceRoot);
                scanner.addDefaultExcludes();
                scanner.setIncludes(new String[]{"META-INF/*.tld"});
                scanner.scan();
                String[] tldFiles = scanner.getIncludedFiles();
                for (int k = 0; k < tldFiles.length; ++k) {
                    File sourceFile = new File(resourceDirectory, tldFiles[k]);
                    File targetFile = new File(targetDir, sourceFile.getName());
                    if (targetFile.exists()) {
                        targetFile.delete();
                    }
                    FileUtils.copyFile((File)sourceFile, (File)targetFile);
                }
            }
        }
        TreeMap<String, ArrayList<File>> sourceMap = new TreeMap<String, ArrayList<File>>();
        Iterator<Object> i2 = artifacts.iterator();
        while (i2.hasNext()) {
            Artifact artifact = (Artifact)i2.next();
            if (this.isDependentProject(artifact.getDependencyConflictId()) || !"jar".equals(artifact.getType())) continue;
            File file = artifact.getFile();
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> jarEntries = jarFile.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String name = jarEntry.getName();
                if (!name.startsWith("META-INF/") || !name.endsWith(".tld")) continue;
                ArrayList<File> taglibs = (ArrayList<File>)sourceMap.get(name);
                if (taglibs == null) {
                    taglibs = new ArrayList<File>();
                    sourceMap.put(name, taglibs);
                }
                taglibs.add(file);
            }
        }
        i2 = sourceMap.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry e = (Map.Entry)i2.next();
            List taglibs = (List)e.getValue();
            String name = (String)e.getKey();
            Iterator ti = taglibs.iterator();
            while (ti.hasNext()) {
                File file = (File)ti.next();
                File sourceFile = new File(name);
                StringBuffer buff = new StringBuffer(sourceFile.getName());
                if (taglibs.size() > 1) {
                    String jarName = file.getName().substring(0, file.getName().length() - ".jar".length());
                    buff.insert(buff.length() - ".tld".length(), "-" + jarName);
                }
                URL jarURL = file.toURL();
                URL sourceURL = new URL("jar:" + jarURL.toExternalForm() + "!/" + name);
                File targetFile = new File(targetDir, buff.toString());
                if (targetFile.exists()) {
                    targetFile.delete();
                }
                FileUtils.copyURLToFile((URL)sourceURL, (File)targetFile);
                targetFile.setReadOnly();
            }
        }
    }

    private void replaceOutputDirectory(File projectDir, File outputDir, Xpp3Dom projectDOM) throws XmlPullParserException {
        Xpp3Dom projectPathsDOM = this.findNamedChild(projectDOM, "hash", "oracle.jdevimpl.config.JProjectPaths");
        Xpp3Dom sourceDOM = new Xpp3Dom("url");
        sourceDOM.setAttribute("path", this.getRelativeDir(projectDir, outputDir));
        sourceDOM.setAttribute("n", "outputDirectory");
        projectPathsDOM.addChild(sourceDOM);
    }

    private File getJProjectFile(MavenProject project) {
        String jprName = project.getArtifactId() + ".jpr";
        return new File(project.getBasedir(), jprName);
    }

    private File getJProjectTestFile(MavenProject project) {
        String jprName = project.getArtifactId() + "-test.jpr";
        return new File(project.getBasedir(), jprName);
    }

    private File getJWorkspaceFile(MavenProject project) {
        String jwsName = project.getArtifactId() + ".jws";
        return new File(project.getBasedir(), jwsName);
    }

    private Xpp3Dom readWorkspaceDOM(File workspaceFile) throws IOException, XmlPullParserException {
        return this.readDOM(workspaceFile, this.release + "/workspace.xml");
    }

    private Xpp3Dom readProjectDOM(File projectFile) throws IOException, XmlPullParserException {
        return this.readDOM(projectFile, this.release + "/project.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Xpp3Dom readDOM(File sourceFile, String resourcePath) throws IOException, XmlPullParserException {
        Xpp3Dom xpp3Dom;
        InputStreamReader reader = null;
        try {
            if (!this.force && sourceFile.exists()) {
                reader = new FileReader(sourceFile);
            } else {
                URL resource = ((Object)((Object)this)).getClass().getResource(resourcePath);
                if (resource == null) {
                    throw new IOException("Unable to read resource: " + resourcePath);
                }
                reader = new InputStreamReader(resource.openStream());
            }
            xpp3Dom = Xpp3DomBuilder.build((Reader)reader);
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close((Reader)reader);
        return xpp3Dom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDOM(File targetFile, Xpp3Dom sourceDOM) throws IOException, XmlPullParserException {
        FileWriter writer = null;
        try {
            writer = new FileWriter(targetFile);
            Xpp3DomWriter.write((Writer)writer, (Xpp3Dom)sourceDOM);
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Writer)writer);
    }

    private String getRelativeDir(File source, File target) {
        return this.getRelativePath(source, target, true);
    }

    private String getRelativeFile(File source, File target) {
        return this.getRelativePath(source, target, false);
    }

    private String getRelativePath(File source, File target, boolean isDirectory) {
        String sourcePath = source.getAbsolutePath();
        String targetPath = target.getAbsolutePath();
        if (targetPath.startsWith(sourcePath + File.separatorChar)) {
            String relativePath = targetPath.substring(sourcePath.length() + 1);
            relativePath = relativePath.replace(File.separatorChar, '/');
            if (isDirectory) {
                relativePath = relativePath + "/";
            }
            return relativePath;
        }
        String[] sourcePaths = sourcePath.split("\\" + File.separator);
        String[] targetPaths = targetPath.split("\\" + File.separator);
        if (System.getProperty("os.name").startsWith("Windows")) {
            sourcePaths[0] = sourcePaths[0].toUpperCase();
            targetPaths[0] = targetPaths[0].toUpperCase();
        }
        int sourcePathCount = sourcePaths.length;
        int targetPathCount = targetPaths.length;
        int commonPathCount = 0;
        int minPathCount = Math.min(sourcePathCount, targetPathCount);
        for (int i = 0; i < minPathCount; ++i) {
            if (!sourcePaths[i].equals(targetPaths[i])) continue;
            ++commonPathCount;
        }
        if (commonPathCount > 0) {
            int i;
            int sourceRelativePathCount = sourcePathCount - commonPathCount;
            int targetRelativePathCount = targetPathCount - commonPathCount;
            int relativePathCount = sourceRelativePathCount + targetRelativePathCount;
            String[] relativePaths = new String[relativePathCount];
            for (i = 0; i < sourceRelativePathCount; ++i) {
                relativePaths[i] = "..";
            }
            for (i = 0; i < targetRelativePathCount; ++i) {
                relativePaths[sourceRelativePathCount + i] = targetPaths[commonPathCount + i];
            }
            StringBuffer relativePath = new StringBuffer();
            for (int i2 = 0; i2 < relativePathCount; ++i2) {
                if (i2 > 0) {
                    relativePath.append("/");
                }
                relativePath.append(relativePaths[i2]);
            }
            return relativePath.toString();
        }
        return targetPath;
    }

    private Xpp3Dom findNamedChild(Xpp3Dom parent, String childName, String attrValue) {
        Xpp3Dom[] hash = parent.getChildren(childName);
        for (int i = 0; i < hash.length; ++i) {
            if (!attrValue.equals(hash[i].getAttribute("n"))) continue;
            return hash[i];
        }
        Xpp3Dom child = new Xpp3Dom(childName);
        child.setAttribute("n", attrValue);
        parent.addChild(child);
        return child;
    }

    private MavenProject findDependentProject(String dependencyManagementKey) {
        Iterator i = this.reactorProjects.iterator();
        while (i.hasNext()) {
            MavenProject reactorProject = (MavenProject)i.next();
            String ident = reactorProject.getArtifact().getDependencyConflictId();
            if (!ident.equals(dependencyManagementKey)) continue;
            return reactorProject.getExecutionProject();
        }
        return null;
    }

    private boolean isDependentProject(String dependencyManagementKey) {
        return this.findDependentProject(dependencyManagementKey) != null;
    }

    private void removeChildren(Xpp3Dom parent) {
        while (parent.getChildCount() != 0) {
            parent.removeChild(0);
        }
    }

    private Xpp3Dom createProjectReferenceDOM(File workspaceDir, File projectFile) {
        Xpp3Dom hashDOM = new Xpp3Dom("hash");
        Xpp3Dom urlDOM = new Xpp3Dom("url");
        urlDOM.setAttribute("n", "URL");
        urlDOM.setAttribute("path", this.getRelativeFile(workspaceDir, projectFile));
        if (this._releaseMajor < 11) {
            Xpp3Dom valueDOM = new Xpp3Dom("value");
            valueDOM.setAttribute("n", "nodeClass");
            valueDOM.setAttribute("v", "oracle.jdeveloper.model.JProject");
            hashDOM.addChild(valueDOM);
        }
        hashDOM.addChild(urlDOM);
        return hashDOM;
    }

    private void _parseRelease() {
        String[] nums = this.release.split("\\.");
        try {
            this._releaseMajor = Integer.parseInt(nums[0]);
        }
        catch (NumberFormatException e) {
            this._releaseMajor = 10;
        }
    }
}

