/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.xml;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.RowPublisher;
import org.apache.metamodel.data.RowPublisherDataSet;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.ImmutableSchema;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.Action;
import org.apache.metamodel.util.FileResource;
import org.apache.metamodel.util.Ref;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.xml.XmlSaxContentHandler;
import org.apache.metamodel.xml.XmlSaxTableDef;
import org.apache.metamodel.xml.XmlStopParsingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSaxDataContext
extends QueryPostprocessDataContext {
    private static final Logger logger = LoggerFactory.getLogger(XmlSaxDataContext.class);
    public static final String COLUMN_NAME_ROW_ID = "row_id";
    private final Ref<InputSource> _inputSourceRef;
    private final Map<XmlSaxTableDef, Map<String, String>> _valueXpaths;
    private String _schemaName;
    private XmlSaxTableDef[] _tableDefs;

    public XmlSaxDataContext(Ref<InputSource> inputSourceRef, XmlSaxTableDef ... tableDefs) {
        this._inputSourceRef = inputSourceRef;
        this._tableDefs = tableDefs;
        this._valueXpaths = new HashMap<XmlSaxTableDef, Map<String, String>>();
        this._schemaName = null;
        for (XmlSaxTableDef tableDef : tableDefs) {
            String[] valueXpaths;
            LinkedHashMap<String, String> xpathMap = new LinkedHashMap<String, String>();
            this._valueXpaths.put(tableDef, xpathMap);
            for (String valueXpath : valueXpaths = tableDef.getValueXpaths()) {
                xpathMap.put(this.getName(tableDef, valueXpath), valueXpath);
            }
        }
    }

    public XmlSaxDataContext(Resource resource, XmlSaxTableDef ... tableDefs) {
        this(XmlSaxDataContext.createInputSourceRef(resource), tableDefs);
    }

    public XmlSaxDataContext(File file, XmlSaxTableDef ... tableDefs) {
        this(XmlSaxDataContext.createInputSourceRef((Resource)new FileResource(file)), tableDefs);
    }

    private static Ref<InputSource> createInputSourceRef(final Resource resource) {
        return new Ref<InputSource>(){

            public InputSource get() {
                InputStream in = resource.read();
                return new InputSource(in);
            }
        };
    }

    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema schema = new MutableSchema(this.getMainSchemaName());
        for (XmlSaxTableDef tableDef : this._tableDefs) {
            String rowXpath = tableDef.getRowXpath();
            MutableTable table = new MutableTable(this.getTableName(tableDef)).setSchema((Schema)schema).setRemarks("XPath: " + rowXpath);
            MutableColumn rowIndexColumn = new MutableColumn(COLUMN_NAME_ROW_ID, ColumnType.INTEGER).setColumnNumber(0).setNullable(Boolean.valueOf(false)).setTable((Table)table).setRemarks("Row/tag index (0-based)");
            table.addColumn((Column)rowIndexColumn);
            for (String valueXpath : tableDef.getValueXpaths()) {
                MutableColumn column = new MutableColumn(this.getName(tableDef, valueXpath)).setRemarks("XPath: " + valueXpath);
                if (valueXpath.startsWith("index(") && valueXpath.endsWith(")")) {
                    column.setType(ColumnType.INTEGER);
                } else {
                    column.setType(ColumnType.VARCHAR);
                }
                column.setTable((Table)table);
                table.addColumn((Column)column);
            }
            schema.addTable(table);
        }
        return new ImmutableSchema((Schema)schema);
    }

    private XmlSaxTableDef getTableDef(Table table) {
        for (XmlSaxTableDef tableDef : this._tableDefs) {
            if (!this.getTableName(tableDef).equals(table.getName())) continue;
            return tableDef;
        }
        throw new IllegalArgumentException("No table def found for table " + table);
    }

    private String getTableName(XmlSaxTableDef tableDef) {
        String xpath = tableDef.getRowXpath();
        int lastIndexOf = xpath.lastIndexOf(47);
        if (lastIndexOf != -1) {
            xpath = xpath.substring(lastIndexOf);
        }
        return xpath;
    }

    private String getName(XmlSaxTableDef tableDef, String xpath) {
        String rowXpath = tableDef.getRowXpath();
        if (xpath.startsWith(rowXpath)) {
            xpath = xpath.substring(rowXpath.length());
        }
        return xpath;
    }

    protected String getMainSchemaName() throws MetaModelException {
        if (this._schemaName == null) {
            try {
                SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                SAXParser saxParser = saxFactory.newSAXParser();
                XMLReader xmlReader = saxParser.getXMLReader();
                xmlReader.setContentHandler(new DefaultHandler(){

                    @Override
                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if (qName != null && qName.length() > 0) {
                            XmlSaxDataContext.this._schemaName = '/' + qName;
                            throw new XmlStopParsingException();
                        }
                    }
                });
                xmlReader.parse((InputSource)this._inputSourceRef.get());
            }
            catch (XmlStopParsingException e) {
                logger.debug("Parsing stop signal thrown");
            }
            catch (Exception e) {
                logger.error("Unexpected error occurred while retrieving schema name", (Throwable)e);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new IllegalStateException(e);
            }
        }
        return this._schemaName;
    }

    protected DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        final XmlSaxTableDef tableDef = this.getTableDef(table);
        final String[] valueXpaths = new String[columns.length];
        SelectItem[] selectItems = new SelectItem[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            selectItems[i] = new SelectItem(column);
            valueXpaths[i] = this.getXpath(tableDef, column);
        }
        Action<RowPublisher> rowPublisherAction = new Action<RowPublisher>(){

            public void run(RowPublisher rowPublisher) throws Exception {
                SAXParserFactory saxFactory = SAXParserFactory.newInstance();
                SAXParser saxParser = saxFactory.newSAXParser();
                XMLReader xmlReader = saxParser.getXMLReader();
                xmlReader.setContentHandler(new XmlSaxContentHandler(tableDef.getRowXpath(), rowPublisher, valueXpaths));
                try {
                    xmlReader.parse((InputSource)XmlSaxDataContext.this._inputSourceRef.get());
                }
                catch (XmlStopParsingException e) {
                    logger.debug("Parsing stop signal thrown");
                }
                catch (Exception e) {
                    logger.warn("Unexpected error occurred while parsing", (Throwable)e);
                    throw e;
                }
                finally {
                    rowPublisher.finished();
                }
            }
        };
        return new RowPublisherDataSet(selectItems, maxRows, (Action)rowPublisherAction);
    }

    private String getXpath(XmlSaxTableDef tableDef, Column column) {
        String columnName = column.getName();
        if (COLUMN_NAME_ROW_ID.equals(columnName)) {
            return "index(" + tableDef.getRowXpath() + ")";
        }
        String result = this._valueXpaths.get(tableDef).get(columnName);
        if (result == null) {
            return columnName;
        }
        return result;
    }
}

