/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.spring;

import java.sql.Connection;
import java.sql.DriverManager;
import javax.sql.DataSource;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.spring.AbstractDataContextFactoryBeanDelegate;
import org.apache.metamodel.spring.DataContextFactoryParameters;

public class JdbcDataContextFactoryBeanDelegate
extends AbstractDataContextFactoryBeanDelegate {
    @Override
    public DataContext createDataContext(DataContextFactoryParameters params) {
        DataSource dataSource;
        TableType[] tableTypes = params.getTableTypes();
        if (tableTypes == null) {
            tableTypes = TableType.DEFAULT_TABLE_TYPES;
        }
        if ((dataSource = params.getDataSource()) == null) {
            Connection connection;
            String driverClassName = this.getString(params.getDriverClassName(), null);
            if (driverClassName != null) {
                try {
                    Class.forName(driverClassName);
                }
                catch (ClassNotFoundException e) {
                    this.logger.error("Failed to initialize JDBC driver class '" + driverClassName + "'!", (Throwable)e);
                }
            }
            String url = params.getUrl();
            try {
                connection = params.getUsername() == null && params.getPassword() == null ? DriverManager.getConnection(url) : DriverManager.getConnection(url, params.getUsername(), params.getPassword());
            }
            catch (Exception e) {
                this.logger.error("Failed to get JDBC connection using URL: " + url, (Throwable)e);
                throw new IllegalStateException("Failed to get JDBC connection", e);
            }
            return new JdbcDataContext(connection, tableTypes, params.getCatalogName());
        }
        return new JdbcDataContext(dataSource, tableTypes, params.getCatalogName());
    }
}

