/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.spring;

import javax.sql.DataSource;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.schema.TableType;
import org.apache.metamodel.spring.CouchDbDataContextFactoryBeanDelegate;
import org.apache.metamodel.spring.CsvDataContextFactoryBeanDelegate;
import org.apache.metamodel.spring.DataContextFactoryBeanDelegate;
import org.apache.metamodel.spring.DataContextFactoryParameters;
import org.apache.metamodel.spring.ExcelDataContextFactoryBeanDelegate;
import org.apache.metamodel.spring.JdbcDataContextFactoryBeanDelegate;
import org.apache.metamodel.spring.MongoDbDataContextFactoryBeanDelegate;
import org.apache.metamodel.spring.PojoDataContextFactoryBeanDelegate;
import org.apache.metamodel.util.SimpleTableDef;
import org.apache.metamodel.util.SimpleTableDefParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;

public class DataContextFactoryBean
implements FactoryBean<DataContext>,
DataContextFactoryParameters {
    private static final Logger logger = LoggerFactory.getLogger(DataContextFactoryBean.class);
    private String _type;
    private Resource _resource;
    private String _filename;
    private String _url;
    private String _columnNameLineNumber;
    private String _skipEmptyLines;
    private String _skipEmptyColumns;
    private String _encoding;
    private String _separatorChar;
    private String _quoteChar;
    private String _escapeChar;
    private String _failOnInconsistentRowLength;
    private String _multilineValues;
    private TableType[] _tableTypes;
    private String _catalogName;
    private DataSource _dataSource;
    private String _username;
    private String _password;
    private String _driverClassName;
    private String _hostname;
    private Integer _port;
    private String _databaseName;
    private SimpleTableDef[] _tableDefs;

    public DataContext getObject() throws Exception {
        String type;
        String string = type = this._type == null ? "" : this._type.toLowerCase();
        if (type.isEmpty()) {
            throw new IllegalArgumentException("No DataContext 'type' property provided for DataContextFactoryBean");
        }
        DataContextFactoryBeanDelegate delegate = "csv".equals(type) ? new CsvDataContextFactoryBeanDelegate() : ("excel".equals(type) ? new ExcelDataContextFactoryBeanDelegate() : ("jdbc".equals(type) ? new JdbcDataContextFactoryBeanDelegate() : ("couchdb".equals(type) ? new CouchDbDataContextFactoryBeanDelegate() : ("mongodb".equals(type) ? new MongoDbDataContextFactoryBeanDelegate() : ("pojo".equals(type) ? new PojoDataContextFactoryBeanDelegate() : this.createDelegateFromType())))));
        if (delegate == null) {
            throw new UnsupportedOperationException("Unsupported DataContext type: " + this._type);
        }
        DataContext dataContext = delegate.createDataContext(this);
        if (dataContext == null) {
            throw new IllegalStateException("Factory method failed to produce a non-null DataContext instance");
        }
        return dataContext;
    }

    private DataContextFactoryBeanDelegate createDelegateFromType() {
        Class<?> cls;
        try {
            logger.debug("Attempting to interpret type '{}' as a delegate class name", (Object)this._type);
            cls = Class.forName(this._type.trim());
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to load type '" + this._type + "' as a class", (Throwable)e);
            }
            return null;
        }
        if (cls == null) {
            return null;
        }
        if (!DataContextFactoryBeanDelegate.class.isAssignableFrom(cls)) {
            return null;
        }
        try {
            DataContextFactoryBeanDelegate delegate = cls.asSubclass(DataContextFactoryBeanDelegate.class).newInstance();
            return delegate;
        }
        catch (Exception e) {
            logger.warn("Failed to instantiate delegate " + cls, (Throwable)e);
            return null;
        }
    }

    public void setTableDefinitions(String tableDefinitionsText) throws IllegalArgumentException {
        this._tableDefs = SimpleTableDefParser.parseTableDefs((String)tableDefinitionsText);
    }

    public Class<DataContext> getObjectType() {
        return DataContext.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    @Override
    public Resource getResource() {
        return this._resource;
    }

    public void setResource(Resource resource) {
        this._resource = resource;
    }

    @Override
    public String getFilename() {
        return this._filename;
    }

    public void setFilename(String filename) {
        this._filename = filename;
    }

    @Override
    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    @Override
    public String getColumnNameLineNumber() {
        return this._columnNameLineNumber;
    }

    public void setColumnNameLineNumber(String columnNameLineNumber) {
        this._columnNameLineNumber = columnNameLineNumber;
    }

    @Override
    public String getSkipEmptyLines() {
        return this._skipEmptyLines;
    }

    public void setSkipEmptyLines(String skipEmptyLines) {
        this._skipEmptyLines = skipEmptyLines;
    }

    @Override
    public String getSkipEmptyColumns() {
        return this._skipEmptyColumns;
    }

    public void setSkipEmptyColumns(String skipEmptyColumns) {
        this._skipEmptyColumns = skipEmptyColumns;
    }

    @Override
    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    @Override
    public String getSeparatorChar() {
        return this._separatorChar;
    }

    public void setSeparatorChar(String separatorChar) {
        this._separatorChar = separatorChar;
    }

    @Override
    public String getQuoteChar() {
        return this._quoteChar;
    }

    public void setQuoteChar(String quoteChar) {
        this._quoteChar = quoteChar;
    }

    @Override
    public String getEscapeChar() {
        return this._escapeChar;
    }

    public void setEscapeChar(String escapeChar) {
        this._escapeChar = escapeChar;
    }

    @Override
    public String getFailOnInconsistentRowLength() {
        return this._failOnInconsistentRowLength;
    }

    public void setFailOnInconsistentRowLength(String failOnInconsistentRowLength) {
        this._failOnInconsistentRowLength = failOnInconsistentRowLength;
    }

    @Override
    public String getMultilineValues() {
        return this._multilineValues;
    }

    public void setMultilineValues(String multilineValues) {
        this._multilineValues = multilineValues;
    }

    @Override
    public TableType[] getTableTypes() {
        return this._tableTypes;
    }

    public void setTableTypes(TableType[] tableTypes) {
        this._tableTypes = tableTypes;
    }

    @Override
    public String getCatalogName() {
        return this._catalogName;
    }

    public void setCatalogName(String catalogName) {
        this._catalogName = catalogName;
    }

    @Override
    public DataSource getDataSource() {
        return this._dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    @Override
    public String getUsername() {
        return this._username;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    @Override
    public String getDriverClassName() {
        return this._driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this._driverClassName = driverClassName;
    }

    @Override
    public String getHostname() {
        return this._hostname;
    }

    public void setHostname(String hostname) {
        this._hostname = hostname;
    }

    @Override
    public Integer getPort() {
        return this._port;
    }

    public void setPort(Integer port) {
        this._port = port;
    }

    @Override
    public String getDatabaseName() {
        return this._databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this._databaseName = databaseName;
    }

    @Override
    public SimpleTableDef[] getTableDefs() {
        return this._tableDefs;
    }

    public void setTableDefs(SimpleTableDef[] tableDefs) {
        this._tableDefs = tableDefs;
    }
}

