/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.spring;

import org.apache.metamodel.spring.DataContextFactoryBeanDelegate;
import org.apache.metamodel.spring.DataContextFactoryParameters;
import org.apache.metamodel.spring.SpringResource;
import org.apache.metamodel.util.BooleanComparator;
import org.apache.metamodel.util.FileResource;
import org.apache.metamodel.util.Resource;
import org.apache.metamodel.util.UrlResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataContextFactoryBeanDelegate
implements DataContextFactoryBeanDelegate {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected Resource getResource(DataContextFactoryParameters params) {
        org.springframework.core.io.Resource resource = params.getResource();
        if (resource != null) {
            return new SpringResource(resource);
        }
        if (params.getFilename() != null) {
            return new FileResource(params.getFilename());
        }
        if (params.getUrl() != null) {
            return new UrlResource(params.getUrl());
        }
        return null;
    }

    protected int getInt(String value, int ifNull) {
        if (value == null) {
            return ifNull;
        }
        if ((value = value.trim()).isEmpty()) {
            return ifNull;
        }
        return Integer.parseInt(value);
    }

    protected String getString(String value, String ifNull) {
        if (value == null) {
            return ifNull;
        }
        if ((value = value.trim()).isEmpty()) {
            return ifNull;
        }
        return value;
    }

    protected char getChar(String value, char ifNull) {
        if (value == null) {
            return ifNull;
        }
        if ((value = value.trim()).isEmpty()) {
            return ifNull;
        }
        if ("none".equalsIgnoreCase(value)) {
            return '\uffff';
        }
        return value.charAt(0);
    }

    protected boolean getBoolean(String value, boolean ifNull) {
        if (value == null) {
            return ifNull;
        }
        if ((value = value.trim()).isEmpty()) {
            return ifNull;
        }
        return BooleanComparator.parseBoolean((String)value);
    }
}

